/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import java.io.IOException;
import java.io.InputStream;

public class LZFDecoder {
    private static final byte BYTE_NULL = 0;
    private static final int HEADER_BYTES = 5;

    private LZFDecoder() {
    }

    public static byte[] decode(byte[] inputBuffer) throws IOException {
        byte[] result = new byte[LZFDecoder.calculateUncompressedSize(inputBuffer, 0, inputBuffer.length)];
        LZFDecoder.decode(inputBuffer, 0, inputBuffer.length, result);
        return result;
    }

    public static byte[] decode(byte[] inputBuffer, int inputPtr, int inputLen) throws IOException {
        byte[] result = new byte[LZFDecoder.calculateUncompressedSize(inputBuffer, inputPtr, inputLen)];
        LZFDecoder.decode(inputBuffer, inputPtr, inputLen, result);
        return result;
    }

    public static int decode(byte[] inputBuffer, byte[] targetBuffer) throws IOException {
        return LZFDecoder.decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public static int decode(byte[] sourceBuffer, int inPtr, int inLength, byte[] targetBuffer) throws IOException {
        byte[] result = targetBuffer;
        int outPtr = 0;
        int blockNr = 0;
        int end = inPtr + inLength - 1;
        while (inPtr < end) {
            if (sourceBuffer[inPtr] != 90 || sourceBuffer[inPtr + 1] != 86) {
                throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + inPtr + "): did not start with 'ZV' signature bytes");
            }
            inPtr += 2;
            byte type = sourceBuffer[inPtr++];
            int len = LZFDecoder.uint16(sourceBuffer, inPtr);
            inPtr += 2;
            if (type == 0) {
                System.arraycopy(sourceBuffer, inPtr, result, outPtr, len);
                outPtr += len;
            } else {
                int uncompLen = LZFDecoder.uint16(sourceBuffer, inPtr);
                LZFDecoder.decompressChunk(sourceBuffer, inPtr += 2, result, outPtr, outPtr + uncompLen);
                outPtr += uncompLen;
            }
            inPtr += len;
            ++blockNr;
        }
        return outPtr;
    }

    public static int calculateUncompressedSize(byte[] data, int ptr, int length) throws IOException {
        int uncompressedSize = 0;
        int blockNr = 0;
        int end = ptr + length;
        while (ptr < end) {
            if (ptr == data.length + 1 && data[ptr] == 0) {
                ++ptr;
                break;
            }
            try {
                if (data[ptr] != 90 || data[ptr + 1] != 86) {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): did not start with 'ZV' signature bytes");
                }
                byte type = data[ptr + 2];
                int blockLen = LZFDecoder.uint16(data, ptr + 3);
                if (type == 0) {
                    ptr += 5;
                    uncompressedSize += blockLen;
                } else if (type == 1) {
                    uncompressedSize += LZFDecoder.uint16(data, ptr + 5);
                    ptr += 7;
                } else {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): unrecognized block type " + (type & 0xFF));
                }
                ptr += blockLen;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): truncated block header");
            }
            ++blockNr;
        }
        if (ptr != data.length) {
            throw new IOException("Corrupt input data: block #" + blockNr + " extends " + (data.length - ptr) + " beyond end of input");
        }
        return uncompressedSize;
    }

    public static int decompressChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        int bytesInOutput;
        int bytesRead = LZFDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            throw new IOException("Corrupt input data, block did not start with 2 byte signature ('ZV') followed by type byte, 2-byte length)");
        }
        byte type = inputBuffer[2];
        int compLen = LZFDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            LZFDecoder.readFully(is, false, outputBuffer, 0, compLen);
            bytesInOutput = compLen;
        } else {
            LZFDecoder.readFully(is, true, inputBuffer, 0, 2 + compLen);
            int uncompLen = LZFDecoder.uint16(inputBuffer, 0);
            LZFDecoder.decompressChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
            bytesInOutput = uncompLen;
        }
        return bytesInOutput;
    }

    public static void decompressChunk(byte[] in, int inPos, byte[] out, int outPos, int outEnd) throws IOException {
        do {
            int ctrl;
            if ((ctrl = in[inPos++] & 0xFF) < 32) {
                switch (ctrl) {
                    case 31: {
                        out[outPos++] = in[inPos++];
                    }
                    case 30: {
                        out[outPos++] = in[inPos++];
                    }
                    case 29: {
                        out[outPos++] = in[inPos++];
                    }
                    case 28: {
                        out[outPos++] = in[inPos++];
                    }
                    case 27: {
                        out[outPos++] = in[inPos++];
                    }
                    case 26: {
                        out[outPos++] = in[inPos++];
                    }
                    case 25: {
                        out[outPos++] = in[inPos++];
                    }
                    case 24: {
                        out[outPos++] = in[inPos++];
                    }
                    case 23: {
                        out[outPos++] = in[inPos++];
                    }
                    case 22: {
                        out[outPos++] = in[inPos++];
                    }
                    case 21: {
                        out[outPos++] = in[inPos++];
                    }
                    case 20: {
                        out[outPos++] = in[inPos++];
                    }
                    case 19: {
                        out[outPos++] = in[inPos++];
                    }
                    case 18: {
                        out[outPos++] = in[inPos++];
                    }
                    case 17: {
                        out[outPos++] = in[inPos++];
                    }
                    case 16: {
                        out[outPos++] = in[inPos++];
                    }
                    case 15: {
                        out[outPos++] = in[inPos++];
                    }
                    case 14: {
                        out[outPos++] = in[inPos++];
                    }
                    case 13: {
                        out[outPos++] = in[inPos++];
                    }
                    case 12: {
                        out[outPos++] = in[inPos++];
                    }
                    case 11: {
                        out[outPos++] = in[inPos++];
                    }
                    case 10: {
                        out[outPos++] = in[inPos++];
                    }
                    case 9: {
                        out[outPos++] = in[inPos++];
                    }
                    case 8: {
                        out[outPos++] = in[inPos++];
                    }
                    case 7: {
                        out[outPos++] = in[inPos++];
                    }
                    case 6: {
                        out[outPos++] = in[inPos++];
                    }
                    case 5: {
                        out[outPos++] = in[inPos++];
                    }
                    case 4: {
                        out[outPos++] = in[inPos++];
                    }
                    case 3: {
                        out[outPos++] = in[inPos++];
                    }
                    case 2: {
                        out[outPos++] = in[inPos++];
                    }
                    case 1: {
                        out[outPos++] = in[inPos++];
                    }
                    case 0: {
                        out[outPos++] = in[inPos++];
                    }
                }
                continue;
            }
            int len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len < 7) {
                out[outPos] = out[outPos++ + (ctrl -= in[inPos++] & 0xFF)];
                out[outPos] = out[outPos++ + ctrl];
                switch (len) {
                    case 6: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 5: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 4: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 3: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 2: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 1: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                }
                continue;
            }
            if ((ctrl -= in[inPos++] & 0xFF) + (len = in[inPos++] & 0xFF) < -9) {
                System.arraycopy(out, outPos + ctrl, out, outPos, len += 9);
                outPos += len;
                continue;
            }
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            int end = (len += outPos) - 3;
            while (outPos < end) {
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
            }
            switch (len - outPos) {
                case 3: {
                    out[outPos] = out[outPos++ + ctrl];
                }
                case 2: {
                    out[outPos] = out[outPos++ + ctrl];
                }
                case 1: {
                    out[outPos] = out[outPos++ + ctrl];
                }
            }
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new IOException("Corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos);
        }
    }

    private static final int uint16(byte[] data, int ptr) {
        return ((data[ptr] & 0xFF) << 8) + (data[ptr + 1] & 0xFF);
    }

    protected static int readHeader(InputStream is, byte[] inputBuffer) throws IOException {
        int needed = 5;
        int count = is.read(inputBuffer, 0, needed);
        if (count == needed) {
            return count;
        }
        if (count <= 0) {
            return 0;
        }
        int offset = count;
        needed -= count;
        while ((count = is.read(inputBuffer, offset, needed)) > 0) {
            offset += count;
            if ((needed -= count) > 0) continue;
        }
        return offset;
    }

    private static final void readFully(InputStream is, boolean compressed, byte[] outputBuffer, int offset, int len) throws IOException {
        int count;
        for (int left = len; left > 0; left -= count) {
            count = is.read(outputBuffer, offset, left);
            if (count < 0) {
                throw new IOException("EOF in " + len + " byte (" + (compressed ? "" : "un") + "compressed) block: could only read " + (len - left) + " bytes");
            }
            offset += count;
        }
    }
}

