/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessControlException;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.LeaderFollowerWorkerThread;
import org.apache.tomcat.util.net.MasterSlaveWorkerThread;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class PoolTcpEndpoint
implements Runnable {
    static Log log = LogFactory.getLog((Class)(class$org$apache$tomcat$util$net$PoolTcpEndpoint == null ? (class$org$apache$tomcat$util$net$PoolTcpEndpoint = PoolTcpEndpoint.class$("org.apache.tomcat.util.net.PoolTcpEndpoint")) : class$org$apache$tomcat$util$net$PoolTcpEndpoint));
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 1000;
    private final Object threadSync = new Object();
    private int backlog = 100;
    private int serverTimeout = 1000;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    private volatile boolean running = false;
    private volatile boolean paused = false;
    private boolean initialized = false;
    private boolean reinitializing = false;
    static final int debug = 0;
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;
    private boolean lf = true;
    private int maxHeaderCount = 100;
    TcpConnectionHandler handler;
    ThreadPoolRunnable listener;
    ThreadPool tp;
    private Thread thread = null;
    private Stack workerThreads = new Stack();
    private int curThreads = 0;
    private int maxThreads = 20;
    private Vector created = new Vector();
    static /* synthetic */ Class class$org$apache$tomcat$util$net$PoolTcpEndpoint;

    public PoolTcpEndpoint() {
        this.tp = new ThreadPool();
    }

    public PoolTcpEndpoint(ThreadPool tp) {
        this.tp = tp;
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxThreads(maxThreads);
        }
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public void setMaxSpareThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxSpareThreads(maxThreads);
        }
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public void setMinSpareThreads(int minThreads) {
        if (minThreads > 0) {
            this.tp.setMinSpareThreads(minThreads);
        }
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public void setThreadPriority(int threadPriority) {
        this.tp.setThreadPriority(threadPriority);
    }

    public int getThreadPriority() {
        return this.tp.getThreadPriority();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getServerSoTimeout() {
        return this.serverTimeout;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public String getStrategy() {
        if (this.lf) {
            return "lf";
        }
        return "ms";
    }

    public void setStrategy(String strategy) {
        this.lf = !"ms".equals(strategy);
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public int getCurrentThreadCount() {
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        return this.curThreads - this.workerThreads.size();
    }

    public void initEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                try {
                    this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
                }
                catch (BindException be) {
                    throw new BindException(be.getMessage() + ":" + this.port);
                }
            }
            if (this.serverTimeout >= 0) {
                this.serverSocket.setSoTimeout(this.serverTimeout);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InstantiationException ex1) {
            throw ex1;
        }
        this.initialized = true;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        if (!this.initialized) {
            this.initEndpoint();
        }
        if (this.lf) {
            this.tp.start();
        }
        this.running = true;
        this.paused = false;
        if (this.lf) {
            this.listener = new LeaderFollowerWorkerThread(this);
            this.tp.runIt(this.listener);
        } else {
            this.maxThreads = this.getMaxThreads();
            this.threadStart();
        }
    }

    public void pauseEndpoint() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resumeEndpoint() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stopEndpoint() {
        if (this.running) {
            if (this.lf) {
                this.tp.shutdown();
            }
            this.running = false;
            if (this.serverSocket != null) {
                this.closeServerSocket();
            }
            if (!this.lf) {
                this.threadStop();
            }
            this.initialized = false;
        }
    }

    protected void closeServerSocket() {
        if (!this.paused) {
            this.unlockAccept();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            log.error((Object)this.sm.getString("endpoint.err.close"), (Throwable)e);
        }
        this.serverSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unlockAccept() {
        Socket s;
        block10: {
            s = null;
            if (this.inet == null) {
                s = new Socket("127.0.0.1", this.port);
                break block10;
            }
            s = new Socket(this.inet, this.port);
            s.setSoLinger(true, 0);
        }
        Object var4_2 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.sm.getString("endpoint.debug.unlock", "" + this.port), (Throwable)e);
                }
                Object var4_3 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket acceptSocket() {
        if (!this.running || this.serverSocket == null) {
            return null;
        }
        Socket accepted = null;
        try {
            accepted = this.factory == null ? this.serverSocket.accept() : this.factory.acceptSocket(this.serverSocket);
            if (null == accepted) {
                log.warn((Object)this.sm.getString("endpoint.warn.nullSocket"));
            } else if (!this.running) {
                accepted.close();
                accepted = null;
            } else if (this.factory != null) {
                this.factory.initSocket(accepted);
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (AccessControlException ace) {
            String msg = this.sm.getString("endpoint.warn.security", this.serverSocket, ace);
            log.warn((Object)msg);
        }
        catch (IOException e) {
            String msg = null;
            if (this.running) {
                msg = this.sm.getString("endpoint.err.nonfatal", this.serverSocket, e);
                log.error((Object)msg, (Throwable)e);
            }
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (Throwable ex) {
                    msg = this.sm.getString("endpoint.err.nonfatal", accepted, ex);
                    log.warn((Object)msg, ex);
                }
                accepted = null;
            }
            if (!this.running) {
                return null;
            }
            this.reinitializing = true;
            Object object = this.threadSync;
            synchronized (object) {
                if (this.reinitializing) {
                    this.reinitializing = false;
                    this.closeServerSocket();
                    this.initialized = false;
                    try {
                        msg = this.sm.getString("endpoint.warn.reinit");
                        log.warn((Object)msg);
                        this.initEndpoint();
                    }
                    catch (Throwable t) {
                        msg = this.sm.getString("endpoint.err.nonfatal", this.serverSocket, t);
                        log.error((Object)msg, t);
                    }
                    if (!this.initialized) {
                        msg = this.sm.getString("endpoint.warn.restart");
                        log.warn((Object)msg);
                        try {
                            this.stopEndpoint();
                            this.initEndpoint();
                            this.startEndpoint();
                        }
                        catch (Throwable t) {
                            msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, t);
                            log.error((Object)msg, t);
                        }
                        throw new ThreadDeath();
                    }
                }
            }
        }
        return accepted;
    }

    void setSocketOptions(Socket socket) throws SocketException {
        if (this.linger >= 0) {
            socket.setSoLinger(true, this.linger);
        }
        if (this.tcpNoDelay) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.socketTimeout > 0) {
            socket.setSoTimeout(this.socketTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSocket(Socket s, TcpConnection con, Object[] threadData) {
        int step = 1;
        try {
            this.setSocketOptions(s);
            step = 2;
            if (this.getServerSocketFactory() != null) {
                this.getServerSocketFactory().handshake(s);
            }
            step = 3;
            con.setEndpoint(this);
            con.setSocket(s);
            this.getConnectionHandler().processConnection(con, threadData);
        }
        catch (SocketException se) {
            log.debug((Object)this.sm.getString("endpoint.err.socket", s.getInetAddress()), (Throwable)se);
            try {
                s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        catch (Throwable t) {
            if (step == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.sm.getString("endpoint.err.handshake"), t);
                }
            } else {
                log.error((Object)this.sm.getString("endpoint.err.unexpected"), t);
            }
            try {
                s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            if (con != null) {
                con.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterSlaveWorkerThread createWorkerThread() {
        Stack stack = this.workerThreads;
        synchronized (stack) {
            if (this.workerThreads.size() > 0) {
                return (MasterSlaveWorkerThread)this.workerThreads.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                return this.newWorkerThread();
            }
            return null;
        }
    }

    private MasterSlaveWorkerThread newWorkerThread() {
        MasterSlaveWorkerThread workerThread = new MasterSlaveWorkerThread(this, this.tp.getName() + "-" + ++this.curThreads);
        workerThread.start();
        this.created.addElement(workerThread);
        return workerThread;
    }

    void recycleWorkerThread(MasterSlaveWorkerThread workerThread) {
        this.workerThreads.push(workerThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            while (this.paused) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            MasterSlaveWorkerThread workerThread = this.createWorkerThread();
            if (workerThread == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            Socket socket = this.acceptSocket();
            workerThread.assign(socket);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    private void threadStart() {
        this.thread = new Thread((Runnable)this, this.tp.getName());
        this.thread.setPriority(this.getThreadPriority());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        this.thread = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

