/*
 * Decompiled with CFR 0.152.
 */
package ints;

import ints.IntArray;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;

public final class WrappedIntArray
implements IntArray {
    private final int[] ia;

    public WrappedIntArray(int[] nArray) {
        this.ia = (int[])nArray.clone();
    }

    public WrappedIntArray(IntStream intStream) {
        this.ia = intStream.toArray();
    }

    public WrappedIntArray(int[] nArray, int n) {
        this.ia = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ia[i] = nArray[i];
        }
    }

    public WrappedIntArray(IntList intList) {
        this.ia = intList.toArray();
    }

    public WrappedIntArray(IntList intList, int n) {
        this.ia = new int[intList.size()];
        for (int i = 0; i < this.ia.length; ++i) {
            int n2 = intList.get(i);
            if (n2 < 0 || n2 >= n) {
                throw new IllegalArgumentException(String.valueOf(n2));
            }
            this.ia[i] = n2;
        }
    }

    @Override
    public int size() {
        return this.ia.length;
    }

    @Override
    public int get(int n) {
        return this.ia[n];
    }

    public String toString() {
        return Arrays.toString(this.ia);
    }

    public int[] toArray() {
        return (int[])this.ia.clone();
    }

    public int binarySearch(int n) {
        return Arrays.binarySearch(this.ia, n);
    }

    public int binarySearch(int n, int n2, int n3) {
        return Arrays.binarySearch(this.ia, n, n2, n3);
    }
}

