/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Options;

public class DescribeInstanceAttribute
extends BaseCmd {
    private static final String[] DISABLE_API_TERMINATION_DESC = new String[]{"Describes a value indicating whether API termination is disabled for", "the instance"};
    private static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Describes the block-device-mapping associated with the instance."};
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"Describes the instance type of the instance."};
    private static final String[] KERNEL_DESC = new String[]{"Describes the ID of the kernel associated with the instance."};
    private static final String[] RAMDISK_DESC = new String[]{"Describes the ID of the ramdisk associated with the instance."};
    private static final String[] ROOT_DEVICE_DESC = new String[]{"Show the root device associated with the specified instance."};
    private static final String[] INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC = new String[]{"Describes the behavior of the instance for an instance initiated", "shutdown (i.e. 'shutdown -h now')."};
    private static final String[] USER_DATA_DESC = new String[]{"Describes the user data associated with the instance."};
    private static final Map<String, InstanceAttribute.InstanceAttributeType> OPTION_ATTRIBUTE_MAPPING = new HashMap<String, InstanceAttribute.InstanceAttributeType>();

    public DescribeInstanceAttribute(String[] args) {
        super("ec2dinatt", new String[]{"ec2-describe-instance-attribute", "ec2diatt"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DescribeInstanceAttribute.createOption("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC));
        result.addOption(DescribeInstanceAttribute.createOption("t", "instance-type", INSTANCE_TYPE_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "disable-api-termination", DISABLE_API_TERMINATION_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "instance-initiated-shutdown-behavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "kernel", KERNEL_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "ramdisk", RAMDISK_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "root-device-name", ROOT_DEVICE_DESC));
        result.addOption(DescribeInstanceAttribute.createOption(null, "user-data", USER_DATA_DESC));
        return result;
    }

    protected String getOptionString() {
        return "INSTANCE [SPECIFIC OPTIONS]";
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("instance-type");
        this.printOption("disable-api-termination");
        this.printOption("instance-initiated-shutdown-behavior");
        this.printOption("kernel");
        this.printOption("ramdisk");
        this.printOption("root-device-name");
        this.printOption("user-data");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes an instance attribute. Only one attribute can be specified per");
        System.out.println("     call.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String instanceId = this.getInstanceId();
        InstanceAttribute.InstanceAttributeType instanceAttributeType = this.getInstanceAttributeType();
        RequestResultPair rsp = jec2.describeInstanceAttribute(instanceId, instanceAttributeType);
        out.outputInstanceAttribute(System.out, instanceId, (InstanceAttribute)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    private InstanceAttribute.InstanceAttributeType getInstanceAttributeType() {
        ArrayList<String> attributes = new ArrayList<String>(1);
        for (String pa : OPTION_ATTRIBUTE_MAPPING.keySet()) {
            if (!this.isOptionSet(pa)) continue;
            attributes.add(pa);
        }
        if (attributes.isEmpty()) {
            throw new InvalidArgumentCombination("An attribute must be specified.");
        }
        if (attributes.size() > 1) {
            throw new InvalidArgumentCombination("Only one attribute may be specified.");
        }
        return OPTION_ATTRIBUTE_MAPPING.get(attributes.get(0));
    }

    protected String getInstanceId() {
        String[] instanceIds = this.getNonOptions();
        if (instanceIds.length == 0) {
            throw new InvalidArgumentCombination("An instance ID must be specified.");
        }
        if (instanceIds.length > 1) {
            throw new InvalidArgumentCombination("Only one instance ID may be specified.");
        }
        return instanceIds[0];
    }

    public static void main(String[] args) {
        new DescribeInstanceAttribute(args).invoke();
    }

    static {
        OPTION_ATTRIBUTE_MAPPING.put("disable-api-termination", InstanceAttribute.InstanceAttributeType.disableApiTermination);
        OPTION_ATTRIBUTE_MAPPING.put("block-device-mapping", InstanceAttribute.InstanceAttributeType.blockDeviceMapping);
        OPTION_ATTRIBUTE_MAPPING.put("instance-type", InstanceAttribute.InstanceAttributeType.instanceType);
        OPTION_ATTRIBUTE_MAPPING.put("kernel", InstanceAttribute.InstanceAttributeType.kernel);
        OPTION_ATTRIBUTE_MAPPING.put("ramdisk", InstanceAttribute.InstanceAttributeType.ramdisk);
        OPTION_ATTRIBUTE_MAPPING.put("root-device-name", InstanceAttribute.InstanceAttributeType.rootDeviceName);
        OPTION_ATTRIBUTE_MAPPING.put("instance-initiated-shutdown-behavior", InstanceAttribute.InstanceAttributeType.instanceInitiatedShutdownBehavior);
        OPTION_ATTRIBUTE_MAPPING.put("user-data", InstanceAttribute.InstanceAttributeType.userData);
    }
}

