/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.html.highlighting.Angular2HtmlHighlightingLexer;
import org.angular2.lang.html.parser.Angular2HtmlElementTypes;
import org.jetbrains.annotations.NotNull;

class Angular2HtmlFileHighlighter
extends HtmlFileHighlighter {
    public static final TextAttributesKey NG_BANANA_BINDING_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.BANANA_BINDING_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey NG_EVENT_BINDING_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.EVENT_BINDING_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey NG_INTERPOLATION_DELIMITER = TextAttributesKey.createTextAttributesKey((String)"NG.SCRIPT_DELIMITERS", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey NG_EXPANSION_FORM_DELIMITER = TextAttributesKey.createTextAttributesKey((String)"NG.EXPANSION_FORM_DELIMITERS", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey NG_PROPERTY_BINDING_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.PROPERTY_BINDING_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey NG_REFERENCE_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.REFERENCE_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
    public static final TextAttributesKey NG_TEMPLATE_BINDINGS_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.TEMPLATE_BINDINGS_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
    public static final TextAttributesKey NG_TEMPLATE_VARIABLE_ATTR_NAME = TextAttributesKey.createTextAttributesKey((String)"NG.TEMPLATE_VARIABLE_ATTR_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
    public static final TextAttributesKey NG_EXPRESSION = TextAttributesKey.createTextAttributesKey((String)"NG.EXPRESSIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
    public static final TextAttributesKey NG_EXPANSION_FORM = TextAttributesKey.createTextAttributesKey((String)"NG.EXPANSION_FORM", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
    public static final TextAttributesKey NG_EXPANSION_FORM_COMMA = TextAttributesKey.createTextAttributesKey((String)"NG.EXPANSION_FORM_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    private static final Map<IElementType, TextAttributesKey[]> keys = new HashMap<IElementType, TextAttributesKey[]>();
    private final boolean myTokenizeExpansionForms;
    private final Pair<String, String> myInterpolationConfig;

    private static void put(IElementType token, TextAttributesKey ... keysArr) {
        keys.put(token, keysArr);
    }

    Angular2HtmlFileHighlighter(boolean tokenizeExpansionForms, Pair<String, String> interpolationConfig) {
        this.myTokenizeExpansionForms = tokenizeExpansionForms;
        this.myInterpolationConfig = interpolationConfig;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        Object[] result = keys.get(tokenType);
        if (result != null) {
            if (result == null) {
                Angular2HtmlFileHighlighter.$$$reportNull$$$0(0);
            }
            return result;
        }
        result = super.getTokenHighlights(tokenType);
        if (tokenType.getLanguage() instanceof Angular2Language || tokenType.getLanguage() instanceof JavascriptLanguage) {
            result = (TextAttributesKey[])ArrayUtil.insert((Object[])result, (int)1, (Object)NG_EXPRESSION);
        }
        if (result == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(1);
        }
        return result;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Angular2HtmlHighlightingLexer angular2HtmlHighlightingLexer = new Angular2HtmlHighlightingLexer(this.myTokenizeExpansionForms, this.myInterpolationConfig, FileTypeRegistry.getInstance().findFileTypeByName("CSS"));
        if (angular2HtmlHighlightingLexer == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(2);
        }
        return angular2HtmlHighlightingLexer;
    }

    static {
        Stream.of(Angular2HtmlElementTypes.INTERPOLATION_START, Angular2HtmlElementTypes.INTERPOLATION_END).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, NG_EXPRESSION, NG_INTERPOLATION_DELIMITER));
        Stream.of(Angular2HtmlElementTypes.EXPANSION_FORM_START, Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START, Angular2HtmlElementTypes.EXPANSION_FORM_END, Angular2HtmlElementTypes.EXPANSION_FORM_CASE_END).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, NG_EXPANSION_FORM, NG_EXPANSION_FORM_DELIMITER));
        Angular2HtmlFileHighlighter.put(Angular2HtmlHighlightingLexer.EXPANSION_FORM_CONTENT, XmlHighlighterColors.HTML_CODE, NG_EXPANSION_FORM);
        Angular2HtmlFileHighlighter.put(Angular2HtmlHighlightingLexer.EXPANSION_FORM_COMMA, XmlHighlighterColors.HTML_CODE, NG_EXPANSION_FORM, NG_EXPANSION_FORM_COMMA);
        Stream.of(Pair.pair((Object)Angular2HtmlElementTypes.BANANA_BOX_BINDING, (Object)NG_BANANA_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.EVENT, (Object)NG_EVENT_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.PROPERTY_BINDING, (Object)NG_PROPERTY_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.REFERENCE, (Object)NG_REFERENCE_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.TEMPLATE_BINDINGS, (Object)NG_TEMPLATE_BINDINGS_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.VARIABLE, (Object)NG_TEMPLATE_VARIABLE_ATTR_NAME)).forEach(p -> Angular2HtmlFileHighlighter.put((IElementType)p.first, XmlHighlighterColors.HTML_CODE, XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_ATTRIBUTE_NAME, (TextAttributesKey)p.second));
        Stream.of(Angular2TokenTypes.KEYWORDS.getTypes()).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, NG_EXPRESSION, JSHighlighter.JS_KEYWORD));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/angular2/lang/html/highlighting/Angular2HtmlFileHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

