/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum V8HeapNodeType {
    kHidden(0, "hidden", "Hidden node, may be filtered when shown to user"),
    kArray(1, "array", "An array of elements"),
    kString(2, "string", "A string"),
    kObject(3, "object", "A JS object (except for arrays and strings)"),
    kCode(4, "compiled code", "Compiled code"),
    kClosure(5, "closure", "Function closure"),
    kRegExp(6, "regexp", "Regular expression"),
    kHeapNumber(7, "number", "Number stored in the heap"),
    kNative(8, "native", "Native object (not from V8 heap)"),
    kSynthetic(9, "synthetic", "Synthetic object, usualy used for grouping snapshot items together"),
    kConsString(10, "concatenated string", "Concatenated string. A pair of pointers to strings."),
    kSlicedString(11, "sliced string", "Sliced string. A fragment of another string."),
    kSymbol(12, "Symbol", "A Symbol (ES6).");

    private final int myNumber;
    private final String myName;
    private final String myDescription;

    private V8HeapNodeType(int number, String name, String description) {
        this.myNumber = number;
        this.myName = name;
        this.myDescription = description;
        Inner.ourMap.put(number, this);
    }

    @Nullable
    public static V8HeapNodeType getByNumber(int number) {
        return (V8HeapNodeType)((Object)Inner.ourMap.get(number));
    }

    public int getNumber() {
        return this.myNumber;
    }

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean isStringType() {
        return this == kConsString || this == kSlicedString || this == kString;
    }

    private static class Inner {
        private static final Map<Integer, V8HeapNodeType> ourMap = new HashMap<Integer, V8HeapNodeType>();

        private Inner() {
        }
    }
}

