/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.ES6Rearranger;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptRearranger
extends ES6Rearranger {
    public TypeScriptRearranger() {
        super(JavaScriptSupportLoader.TYPESCRIPT, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PRIVATE}), ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.ABSTRACT, StdArrangementTokens.Modifier.READONLY}));
    }

    @Override
    protected boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptRearranger.$$$reportNull$$$0(0);
        }
        return DialectDetector.isTypeScript(element);
    }

    @Override
    @NotNull
    protected JSRearrangerBase.Visitor createVisitor(@NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            TypeScriptRearranger.$$$reportNull$$$0(1);
        }
        MyVisitor myVisitor = new MyVisitor(arrangementInfo);
        if (myVisitor == null) {
            TypeScriptRearranger.$$$reportNull$$$0(2);
        }
        return myVisitor;
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            TypeScriptRearranger.$$$reportNull$$$0(3);
        }
        if (entryType == null) {
            TypeScriptRearranger.$$$reportNull$$$0(4);
        }
        if (existingModifiers == null) {
            TypeScriptRearranger.$$$reportNull$$$0(5);
        }
        if (entryType == StdArrangementTokens.EntryType.CONSTRUCTOR) {
            return false;
        }
        if (modifier == StdArrangementTokens.Modifier.READONLY) {
            return entryType == StdArrangementTokens.EntryType.FIELD;
        }
        if (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) {
            return !(existingModifiers.contains(StdArrangementTokens.Modifier.STATIC) && modifier == StdArrangementTokens.Modifier.ABSTRACT || existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) && modifier == StdArrangementTokens.Modifier.STATIC || existingModifiers.contains(StdArrangementTokens.Modifier.PRIVATE) && modifier == StdArrangementTokens.Modifier.ABSTRACT) && (!existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) || modifier != StdArrangementTokens.Modifier.PRIVATE);
        }
        return false;
    }

    @Override
    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            TypeScriptRearranger.$$$reportNull$$$0(6);
        }
        if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
            return type == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE : commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
        }
        return super.getBlankLines(commonSettings, type, parent);
    }

    @NotNull
    private static PsiElement getEndElement(@NotNull JSElement element) {
        ASTNode sibling;
        if (element == null) {
            TypeScriptRearranger.$$$reportNull$$$0(7);
        }
        if ((sibling = element.getNode().getTreeNext()) != null && (sibling.getElementType() == JSTokenTypes.COMMA || sibling.getElementType() == JSTokenTypes.SEMICOLON)) {
            PsiElement psiElement = sibling.getPsi();
            if (psiElement == null) {
                TypeScriptRearranger.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        JSElement jSElement = element;
        if (jSElement == null) {
            TypeScriptRearranger.$$$reportNull$$$0(9);
        }
        return jSElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/TypeScriptRearranger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModifiers";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/TypeScriptRearranger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModifierEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVisitor
    extends JSRearrangerBase.Visitor {
        MyVisitor(JSRearrangerBase.ArrangementInfo arrangementInfo) {
            super(arrangementInfo);
        }

        public void visitTypeScriptInterface(TypeScriptInterface typeScriptInterface) {
            JSElementArrangementEntry interfaceEntry = this.myArrangementInfo.addContainerEntry((PsiElement)typeScriptInterface, StdArrangementTokens.EntryType.INTERFACE);
            if (interfaceEntry == null) {
                return;
            }
            this.myArrangementInfo.processWithCurrentEntry(interfaceEntry, typeScriptInterface, anInterface -> {
                for (JSElement element : anInterface.getMembers()) {
                    ArrangementSettingsToken type;
                    PsiElement endElement = TypeScriptRearranger.getEndElement(element);
                    ArrangementSettingsToken arrangementSettingsToken = type = element instanceof TypeScriptPropertySignature ? StdArrangementTokens.EntryType.FIELD : StdArrangementTokens.EntryType.METHOD;
                    JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromRange((PsiElement)element, endElement, type, (Set<ArrangementSettingsToken>)ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC}), element.getName());
                    if (entry == null) continue;
                    this.visitWithCurrentEntry(element, entry);
                }
            });
        }
    }
}

