/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSSuspiciousInstanceofCheck {
    static void checkInstanceOfGuard(@NotNull ProblemsHolder holder, @NotNull JSBinaryExpression expression, @NotNull ProblemHighlightType highlightType) {
        ProcessingContext context;
        if (holder == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(1);
        }
        if (highlightType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(2);
        }
        if (!DialectDetector.isTypeScript((PsiElement)expression) || !TypeScriptConfigUtil.strictNullChecks((PsiElement)expression)) {
            return;
        }
        JSExpression lOperand = expression.getLOperand();
        JSExpression rOperand = expression.getROperand();
        if (!(lOperand instanceof JSReferenceExpression) || rOperand == null) {
            return;
        }
        PsiElement instanceOf = JSRefactoringUtil.skipWhitespaces(lOperand.getNextSibling(), true);
        if (instanceOf == null) {
            return;
        }
        JSType lType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSTypeWithInferredDecorators((PsiElement)lOperand));
        if (lType == null || lType instanceof JSAnyType) {
            return;
        }
        lType = lType.transformTypeHierarchy(t -> JSSuspiciousTypeUtil.getGenericConstraintSelfOrAny(t));
        JSType rType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSTypeWithInferredDecorators((PsiElement)rOperand));
        if (!(rType instanceof JSTypeImpl)) {
            return;
        }
        if ((rType = TypeScriptUtil.getConstructedType(rType, rOperand)).isDirectlyAssignableType(lType, context = JSTypeComparingContextService.getSubtypingProcessingContext((PsiElement)expression))) {
            Ref inheritor = Ref.create((Object)false);
            if (JSSuspiciousInstanceofCheck.checkInherits(lType, rType, (Ref<Boolean>)inheritor)) {
                return;
            }
            if (lType instanceof JSCompositeTypeImpl) {
                for (JSType part : ((JSCompositeTypeImpl)lType).getTypes()) {
                    if (!JSSuspiciousInstanceofCheck.checkInherits(part, rType, (Ref<Boolean>)inheritor)) continue;
                    return;
                }
            }
            holder.registerProblem(instanceOf, JSBundle.message((String)(inheritor.get() == Boolean.TRUE ? "typescript.redundant.instanceof.inheritor.guard" : "typescript.redundant.instanceof.guard"), (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), highlightType, new LocalQuickFix[0]);
            return;
        }
        if (lType.isDirectlyAssignableType(rType, context)) {
            return;
        }
        if (lType instanceof JSUnionType) {
            for (JSType part : ((JSUnionType)lType).getTypes()) {
                if (!part.isDirectlyAssignableType(rType, context) && !rType.isDirectlyAssignableType(part, context)) continue;
                return;
            }
        }
        holder.registerProblem((PsiElement)expression, JSBundle.message((String)"typescript.suspicious.instanceof.guard", (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), highlightType, new LocalQuickFix[0]);
    }

    private static boolean checkInherits(@NotNull JSType lType, @NotNull JSType rType, @NotNull Ref<Boolean> inheritor) {
        if (lType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(3);
        }
        if (rType == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(4);
        }
        if (inheritor == null) {
            JSSuspiciousInstanceofCheck.$$$reportNull$$$0(5);
        }
        JSResolvableType rResolvable = (JSResolvableType)ObjectUtils.tryCast((Object)TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(rType), JSResolvableType.class);
        JSResolvableType lResolvable = (JSResolvableType)ObjectUtils.tryCast((Object)TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(lType), JSResolvableType.class);
        if (lResolvable == null || rResolvable == null) {
            return false;
        }
        JSClass lClass = lResolvable.resolveType().getDeclarationOfType(JSClass.class);
        JSClass rClass = rResolvable.resolveType().getDeclarationOfType(JSClass.class);
        if (lClass != null && rClass != null && lClass != rClass && !JSInheritanceUtil.isParentClass(lClass, rClass)) {
            return true;
        }
        inheritor.set((Object)true);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousInstanceofCheck";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceOfGuard";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInherits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

