/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.twig.elements.TwigElementTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigBlockStatements
implements TwigElementTypes {
    private static final HashMap<IElementType, StatementDefinition> STATEMENT_BY_START_TAG_MAP = new HashMap();
    private static final HashMap<IElementType, StatementDefinition> STATEMENT_BY_TYPE_MAP = new HashMap();

    private TwigBlockStatements() {
    }

    private static StatementDefinition defineStatement(IElementType statementType, IElementType tagType, IElementType ... terminatorTypes) {
        StatementDefinition definition = new StatementDefinition(statementType, tagType, terminatorTypes);
        STATEMENT_BY_START_TAG_MAP.put(tagType, definition);
        STATEMENT_BY_TYPE_MAP.put(statementType, definition);
        return definition;
    }

    @Nullable
    public static StatementDefinition getStatementDefinitionByStartTag(@Nullable IElementType startTagType) {
        if (startTagType == null) {
            return null;
        }
        return STATEMENT_BY_START_TAG_MAP.get(startTagType);
    }

    @Nullable
    public static StatementDefinition getStatementDefinitionByType(IElementType statementType) {
        return STATEMENT_BY_TYPE_MAP.get(statementType);
    }

    public static boolean isBlockStatement(IElementType type) {
        return STATEMENT_BY_TYPE_MAP.containsKey(type) || type == TwigElementTypes.TWIG_STATEMENT;
    }

    static {
        TwigBlockStatements.defineStatement(IF_STATEMENT, IF_TAG, ENDIF_TAG);
        TwigBlockStatements.defineStatement(ELSE_STATEMENT, ELSE_TAG, new IElementType[0]).endsBefore(ELSE_TAG, ELSEIF_TAG, ENDIF_TAG, ENDFOR_TAG);
        TwigBlockStatements.defineStatement(ELSEIF_STATEMENT, ELSEIF_TAG, new IElementType[0]).endsBefore(ELSE_STATEMENT, ELSEIF_STATEMENT, ENDIF_TAG, ENDFOR_TAG);
        TwigBlockStatements.defineStatement(BLOCK_STATEMENT, BLOCK_TAG, ENDBLOCK_TAG).setMayBeShort(true);
        TwigBlockStatements.defineStatement(FOR_STATEMENT, FOR_TAG, ENDFOR_TAG);
        TwigBlockStatements.defineStatement(FILTER_STATEMENT, FILTER_TAG, ENDFILTER_TAG);
        TwigBlockStatements.defineStatement(AUTOESCAPE_STATEMENT, AUTOESCAPE_TAG, ENDAUTOESCAPE_TAG);
        TwigBlockStatements.defineStatement(MACRO_STATEMENT, MACRO_TAG, ENDMACRO_TAG);
        TwigBlockStatements.defineStatement(SPACELESS_STATEMENT, SPACELESS_TAG, ENDSPACELESS_TAG);
        TwigBlockStatements.defineStatement(EMBED_STATEMENT, EMBED_TAG, ENDEMBED_TAG);
        TwigBlockStatements.defineStatement(SANDBOX_STATEMENT, SANDBOX_TAG, ENDSANDBOX_TAG);
        TwigBlockStatements.defineStatement(VERBATIM_STATEMENT, VERBATIM_TAG, ENDVERBATIM_TAG);
        TwigBlockStatements.defineStatement(RAW_BLOCK, RAW_TAG, ENDRAW_TAG);
        TwigBlockStatements.defineStatement(SET_STATEMENT, SET_TAG, ENDSET_TAG).setMayBeShort(true);
    }

    public static class StatementDefinition {
        private final IElementType statementType;
        private final IElementType startTagType;
        public Set<IElementType> endTagTypes = new HashSet<IElementType>();
        public Set<IElementType> endsBeforeTypes = new HashSet<IElementType>();
        private boolean mayBeShort = false;

        public StatementDefinition(IElementType statementType, IElementType startTagType, IElementType ... endTagTypes) {
            this.statementType = statementType;
            this.startTagType = startTagType;
            Collections.addAll(this.endTagTypes, endTagTypes);
        }

        public IElementType getStatementType() {
            return this.statementType;
        }

        public IElementType getStartTagType() {
            return this.startTagType;
        }

        public void endsBefore(IElementType ... endsBeforTypes) {
            Collections.addAll(this.endsBeforeTypes, endsBeforTypes);
        }

        public boolean isTerminatedOn(IElementType elementType) {
            return this.endTagTypes.contains(elementType);
        }

        public boolean isTerminatedBefore(IElementType elementType) {
            return this.endsBeforeTypes.contains(elementType);
        }

        public boolean mayBeShort() {
            return this.mayBeShort;
        }

        public void setMayBeShort(boolean mayBeShort) {
            this.mayBeShort = mayBeShort;
        }

        public boolean isStartTag(@NotNull IElementType tagType) {
            if (tagType == null) {
                StatementDefinition.$$$reportNull$$$0(0);
            }
            return this.startTagType == tagType;
        }

        public boolean isEndTag(@NotNull IElementType tagType) {
            if (tagType == null) {
                StatementDefinition.$$$reportNull$$$0(1);
            }
            return this.endTagTypes.contains(tagType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tagType";
            objectArray2[1] = "com/jetbrains/twig/parser/TwigBlockStatements$StatementDefinition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStartTag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEndTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

