/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class RainbowDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private final EventDispatcher<OptionsPanelImpl.ColorDescriptionPanel.Listener> myDispatcher;
    protected JPanel myPanel;
    private JBLabel myLStop1;
    private JBLabel myLStop2;
    private JBLabel myLStop3;
    private JBLabel myLStop4;
    private JBLabel myLStop5;
    private final JBLabel[] myLStops;
    protected ColorPanel myStop1;
    protected ColorPanel myStop2;
    protected ColorPanel myStop3;
    protected ColorPanel myStop4;
    protected ColorPanel myStop5;
    private final ColorPanel[] myStops;
    private JBCheckBox myRainbow;
    private JTextPane myInheritanceLabel;
    private JBCheckBox myInheritAttributesBox;

    public RainbowDescriptionPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(OptionsPanelImpl.ColorDescriptionPanel.Listener.class);
        this.myLStops = new JBLabel[]{this.myLStop1, this.myLStop2, this.myLStop3, this.myLStop4, this.myLStop5};
        this.myStops = new ColorPanel[]{this.myStop1, this.myStop2, this.myStop3, this.myStop4, this.myStop5};
        this.add((Component)this.myPanel, "Center");
        this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
        ActionListener actionListener = e -> ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onSettingsChanged(e);
        for (JBCheckBox jBCheckBox : new JBCheckBox[]{this.myRainbow, this.myInheritAttributesBox}) {
            jBCheckBox.addActionListener(actionListener);
        }
        for (JBCheckBox jBCheckBox : new ColorPanel[]{this.myStop1, this.myStop2, this.myStop3, this.myStop4, this.myStop5}) {
            jBCheckBox.addActionListener(actionListener);
        }
        String languageDefaultPageID = OptionsBundle.message((String)"options.language.defaults.display.name", (Object[])new Object[0]);
        String rainbowOptionsID = ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]);
        String style = "<div style=\"text-align:right\" vertical-align=\"top\">";
        String string = "Editor | Color Scheme | " + languageDefaultPageID + "<br>" + rainbowOptionsID;
        String inheritanceText = style + "<a href=\"" + languageDefaultPageID + "\">" + rainbowOptionsID + "</a><br>(" + languageDefaultPageID + ")";
        Messages.configureMessagePaneUi((JTextPane)this.myInheritanceLabel, (String)"<html>", null);
        this.myInheritanceLabel.setText(RainbowDescriptionPanel.checkRightArrow(inheritanceText));
        this.myInheritanceLabel.setToolTipText(RainbowDescriptionPanel.checkRightArrow(string));
        this.myInheritanceLabel.addHyperlinkListener(e -> ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onHyperLinkClicked(e));
        this.myInheritanceLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
    }

    @NotNull
    private static String checkRightArrow(@NotNull String str) {
        if (str == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(0);
        }
        String string = str.replaceAll("->", FontUtil.rightArrow((Font)UIUtil.getLabelFont()));
        if (string == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        RainbowDescriptionPanel rainbowDescriptionPanel = this;
        if (rainbowDescriptionPanel == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(2);
        }
        return rainbowDescriptionPanel;
    }

    @Override
    public void resetDefault() {
    }

    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor attributeDescriptor) {
        boolean isEnable;
        if (attributeDescriptor == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(3);
        }
        if (!(attributeDescriptor instanceof RainbowAttributeDescriptor)) {
            return;
        }
        RainbowAttributeDescriptor descriptor = (RainbowAttributeDescriptor)attributeDescriptor;
        EditorColorsScheme editedColorsScheme = descriptor.getScheme();
        Boolean rainbowOn = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)editedColorsScheme, descriptor.getLanguage());
        boolean isInherited = false;
        boolean isDefaultLanguage = descriptor.getLanguage() == null;
        boolean bl = isEnable = !ColorAndFontOptions.isReadOnly(editedColorsScheme);
        if (rainbowOn == null) {
            isInherited = true;
            rainbowOn = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)editedColorsScheme, null);
        }
        this.myRainbow.setEnabled(isEnable && !isInherited);
        this.myRainbow.setSelected(rainbowOn.booleanValue());
        for (int i = 0; i < this.myLStops.length; ++i) {
            this.myLStops[i].setEnabled(isEnable && isDefaultLanguage);
            this.myStops[i].setEnabled(rainbowOn.booleanValue());
            this.myStops[i].setEditable(isEnable && isDefaultLanguage);
            this.myStops[i].setSelectedColor(editedColorsScheme.getAttributes(RainbowHighlighter.RAINBOW_COLOR_KEYS[i]).getForegroundColor());
        }
        this.myInheritanceLabel.setVisible(!isDefaultLanguage);
        this.myInheritAttributesBox.setEnabled(isEnable);
        this.myInheritAttributesBox.setSelected(isInherited);
        this.myInheritAttributesBox.setVisible(!isDefaultLanguage);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor attributeDescriptor, EditorColorsScheme scheme2) {
        if (attributeDescriptor == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(4);
        }
        if (!(attributeDescriptor instanceof RainbowAttributeDescriptor)) {
            return;
        }
        RainbowAttributeDescriptor descriptor = (RainbowAttributeDescriptor)attributeDescriptor;
        boolean isDefaultLanguage = descriptor.getLanguage() == null;
        RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)scheme2, descriptor.getLanguage(), (Boolean)(isDefaultLanguage ? Boolean.valueOf(this.myRainbow.isSelected()) : (this.myInheritAttributesBox.isSelected() ? null : Boolean.valueOf(this.myRainbow.isSelected()))));
        for (int i = 0; i < this.myStops.length; ++i) {
            scheme2.setAttributes(RainbowHighlighter.RAINBOW_COLOR_KEYS[i], RainbowHighlighter.createRainbowAttribute(this.myStops[i].getSelectedColor()));
        }
        descriptor.apply(scheme2);
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        if (listener2 == null) {
            RainbowDescriptionPanel.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/RainbowDescriptionPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/RainbowDescriptionPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRightArrow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRightArrow";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JTextPane jTextPane;
        JBCheckBox jBCheckBox;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        ColorPanel colorPanel4;
        ColorPanel colorPanel5;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 10, 10, 10), -1, -1, false, false));
        this.myRainbow = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.rainbow"));
        jBCheckBox2.setVerticalTextPosition(0);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 3, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myStop1 = colorPanel5 = new ColorPanel();
        jPanel.add((Component)colorPanel5, new GridConstraints(2, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop2 = colorPanel4 = new ColorPanel();
        jPanel.add((Component)colorPanel4, new GridConstraints(3, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop3 = colorPanel3 = new ColorPanel();
        jPanel.add((Component)colorPanel3, new GridConstraints(4, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop4 = colorPanel2 = new ColorPanel();
        jPanel.add((Component)colorPanel2, new GridConstraints(5, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop5 = colorPanel = new ColorPanel();
        jPanel.add((Component)colorPanel, new GridConstraints(6, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(30, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 0, 0, null, null, null, 0, true));
        this.myInheritAttributesBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.inherit.attributes"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myInheritanceLabel = jTextPane = new JTextPane();
        jTextPane.setText("labl");
        jBScrollPane.setViewportView(jTextPane);
        this.myLStop1 = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.1"));
        jPanel.add((Component)jBLabel5, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop2 = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.2"));
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop3 = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.3"));
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop4 = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.4"));
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop5 = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.5"));
        jPanel.add((Component)jBLabel, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("rainbow.option.description"));
        jPanel.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 3, 0, 3, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

