/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.formatting.contextConfiguration.CodeFragmentCodeStyleSettingsPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureCodeStyleOnSelectedFragment
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(ConfigureCodeStyleOnSelectedFragment.class);
    private static final String ID = "configure.code.style.on.selected.fragment";

    @Nls
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
        if (string == null) {
            ConfigureCodeStyleOnSelectedFragment.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("ConfigureCodeStyleOnSelectedFragment" == null) {
            ConfigureCodeStyleOnSelectedFragment.$$$reportNull$$$0(1);
        }
        return "ConfigureCodeStyleOnSelectedFragment";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ConfigureCodeStyleOnSelectedFragment.$$$reportNull$$$0(2);
        }
        return editor.getSelectionModel().hasSelection() && file2.isWritable() && ConfigureCodeStyleOnSelectedFragment.hasSettingsToShow(editor, file2);
    }

    private static boolean hasSettingsToShow(Editor editor, PsiFile file2) {
        LanguageCodeStyleSettingsProvider provider = ConfigureCodeStyleOnSelectedFragment.getProviderForContext(editor, file2);
        return provider != null && CodeFragmentCodeStyleSettingsPanel.hasOptionsToShow(provider);
    }

    @Nullable
    private static LanguageCodeStyleSettingsProvider getProviderForContext(Editor editor, PsiFile file2) {
        Language language = PsiUtilBase.getLanguageInEditor((Caret)editor.getCaretModel().getCurrentCaret(), (Project)file2.getProject());
        return language != null ? ConfigureCodeStyleOnSelectedFragment.guessSettingsProviderForLanguage(language) : null;
    }

    @Nullable
    private static LanguageCodeStyleSettingsProvider guessSettingsProviderForLanguage(@NotNull Language language) {
        LanguageCodeStyleSettingsProvider exactMatch;
        if (language == null) {
            ConfigureCodeStyleOnSelectedFragment.$$$reportNull$$$0(3);
        }
        if ((exactMatch = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null) {
            return exactMatch;
        }
        LanguageCodeStyleSettingsProvider guessed = null;
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList()) {
            if (!language.isKindOf(provider.getLanguage()) || guessed != null && !provider.getLanguage().isKindOf(guessed.getLanguage())) continue;
            guessed = provider;
        }
        return guessed;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ConfigureCodeStyleOnSelectedFragment.$$$reportNull$$$0(4);
        }
        SelectedTextFormatter textFormatter = new SelectedTextFormatter(project, editor, file2);
        LanguageCodeStyleSettingsProvider settingsProvider = ConfigureCodeStyleOnSelectedFragment.getProviderForContext(editor, file2);
        assert (settingsProvider != null);
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        textFormatter.reformatSelectedText(settings);
        CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow = new CodeStyleSettingsCodeFragmentFilter(file2, textFormatter.getSelectedRange(), settingsProvider).getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS);
        new FragmentCodeStyleSettingsDialog(editor, textFormatter, settingsProvider, settings, settingsToShow).show();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessSettingsProviderForLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FragmentCodeStyleSettingsDialog
    extends DialogWrapper {
        private final CodeFragmentCodeStyleSettingsPanel myTabbedLanguagePanel;
        private final Editor myEditor;
        private final Document myDocument;
        private final SelectedTextFormatter mySelectedTextFormatter;
        private final CodeStyleSettings mySettings;

        FragmentCodeStyleSettingsDialog(@NotNull Editor editor, @NotNull SelectedTextFormatter selectedTextFormatter, @NotNull LanguageCodeStyleSettingsProvider settingsProvider, CodeStyleSettings settings, CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow) {
            if (editor == null) {
                FragmentCodeStyleSettingsDialog.$$$reportNull$$$0(0);
            }
            if (selectedTextFormatter == null) {
                FragmentCodeStyleSettingsDialog.$$$reportNull$$$0(1);
            }
            if (settingsProvider == null) {
                FragmentCodeStyleSettingsDialog.$$$reportNull$$$0(2);
            }
            super((Component)editor.getContentComponent(), true);
            this.mySettings = settings;
            this.mySelectedTextFormatter = selectedTextFormatter;
            this.myTabbedLanguagePanel = new CodeFragmentCodeStyleSettingsPanel(settings, settingsToShow, settingsProvider, selectedTextFormatter);
            this.myOKAction = new ApplyToSettings();
            this.myOKAction.setEnabled(false);
            this.myTabbedLanguagePanel.setOnSomethingChangedCallback(() -> {
                boolean isModified = this.myTabbedLanguagePanel.isModified(this.mySettings);
                this.myOKAction.setEnabled(isModified);
            });
            this.myEditor = editor;
            this.myDocument = editor.getDocument();
            String title = CodeInsightBundle.message((String)"configure.code.style.on.fragment.dialog.title", (Object[])new Object[0]);
            String languageName = (String)ObjectUtils.coalesce((Object)settingsProvider.getLanguageName(), (Object)settingsProvider.getLanguage().getDisplayName());
            this.setTitle(StringUtil.capitalizeWords((String)title, (boolean)true) + ": " + languageName);
            this.setInitialLocationCallback(() -> new DialogPositionProvider().calculateLocation());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTabbedLanguagePanel.getPreferredFocusedComponent();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myTabbedLanguagePanel.getPanel();
        }

        protected void dispose() {
            super.dispose();
            Disposer.dispose((Disposable)this.myTabbedLanguagePanel);
        }

        protected void doOKAction() {
            this.applyFromUiToSettings();
            super.doOKAction();
        }

        private void applyFromUiToSettings() {
            try {
                this.myTabbedLanguagePanel.apply(this.mySettings);
            }
            catch (ConfigurationException e) {
                LOG.debug("Can not apply code style settings from context menu to project code style settings");
            }
        }

        public void doCancelAction() {
            this.mySelectedTextFormatter.restoreSelectedText();
            super.doCancelAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedTextFormatter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsProvider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ApplyToSettingsAndReformat
        extends AbstractAction {
            ApplyToSettingsAndReformat() {
                super("Save and Reformat File");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentCodeStyleSettingsDialog.this.applyFromUiToSettings();
                FragmentCodeStyleSettingsDialog.this.mySelectedTextFormatter.reformatWholeFile();
                FragmentCodeStyleSettingsDialog.super.doOKAction();
            }
        }

        private class ApplyToSettings
        extends AbstractAction
        implements OptionAction {
            private final Action[] myOptions;

            private ApplyToSettings() {
                super("Save");
                this.myOptions = new Action[]{new ApplyToSettingsAndReformat()};
                this.putValue("DefaultAction", Boolean.TRUE);
            }

            @Override
            public void setEnabled(boolean value) {
                super.setEnabled(value);
                for (Action option : this.myOptions) {
                    option.setEnabled(value);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentCodeStyleSettingsDialog.this.doOKAction();
            }

            @NotNull
            public Action[] getOptions() {
                if (this.myOptions == null) {
                    ApplyToSettings.$$$reportNull$$$0(0);
                }
                return this.myOptions;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/ConfigureCodeStyleOnSelectedFragment$FragmentCodeStyleSettingsDialog$ApplyToSettings", "getOptions"));
            }
        }

        private class DialogPositionProvider {
            private static final int PREFERRED_PADDING = 100;
            private final JComponent myEditorComponent;
            private final JComponent myContentComponent;
            private int mySelectionStartY;
            private int mySelectionEndY;
            private int myTextRangeMaxColumnX;
            private final int myEditorComponentWidth;
            private final int myEditorComponentHeight;

            DialogPositionProvider() {
                this.myContentComponent = FragmentCodeStyleSettingsDialog.this.myEditor.getContentComponent();
                this.myEditorComponent = FragmentCodeStyleSettingsDialog.this.myEditor.getComponent();
                this.myEditorComponentWidth = this.myEditorComponent.getWidth();
                this.myEditorComponentHeight = this.myEditorComponent.getHeight();
            }

            public Point calculateLocation() {
                this.calculateSelectedTextRectangle();
                int dialogWidth = FragmentCodeStyleSettingsDialog.this.getSize().width;
                int dialogHeight = FragmentCodeStyleSettingsDialog.this.getSize().height;
                int spaceIfPlacedOnTheRight = this.myEditorComponentWidth - (this.myTextRangeMaxColumnX + dialogWidth);
                Integer dialogX = null;
                Integer dialogY = null;
                if (spaceIfPlacedOnTheRight > 0) {
                    int paddingFromText = spaceIfPlacedOnTheRight > 100 ? 100 : spaceIfPlacedOnTheRight / 2;
                    dialogX = this.myTextRangeMaxColumnX + paddingFromText;
                    dialogY = this.mySelectionEndY - this.mySelectionStartY > dialogHeight ? Integer.valueOf((this.myEditorComponentHeight - dialogHeight) / 2) : this.getYMatchingDialogAndSelectionCenter(dialogHeight);
                } else if (this.mySelectionStartY > dialogHeight) {
                    dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
                    dialogY = this.mySelectionStartY - dialogHeight;
                } else if (this.mySelectionEndY + dialogHeight < this.myEditorComponentHeight) {
                    dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
                    dialogY = this.mySelectionEndY;
                }
                if (dialogX != null && dialogY != null) {
                    Point location = new Point(dialogX, dialogY);
                    SwingUtilities.convertPointToScreen(location, FragmentCodeStyleSettingsDialog.this.myEditor.getComponent());
                    return location;
                }
                return null;
            }

            private Integer getYMatchingDialogAndSelectionCenter(int dialogHeight) {
                int extraBottomSpace;
                int selectionCenter = (this.mySelectionStartY + this.mySelectionEndY) / 2;
                int dialogTop = selectionCenter - dialogHeight / 2;
                int dialogBottom = selectionCenter + dialogHeight / 2;
                if (dialogTop >= 0 && dialogBottom <= this.myEditorComponentHeight) {
                    return dialogTop;
                }
                if (dialogTop < 0) {
                    int extraTopSpace = -dialogTop;
                    if (dialogBottom + extraTopSpace <= this.myEditorComponentHeight) {
                        return 0;
                    }
                } else if (dialogBottom > this.myEditorComponentHeight && dialogTop - (extraBottomSpace = dialogBottom - this.myEditorComponentHeight) >= 0) {
                    return dialogTop - extraBottomSpace;
                }
                return null;
            }

            private void calculateSelectedTextRectangle() {
                SelectionModel selectionModel = FragmentCodeStyleSettingsDialog.this.myEditor.getSelectionModel();
                int selectionStartOffset = selectionModel.getSelectionStart();
                int selectionEndOffset = selectionModel.getSelectionEnd();
                VisualPosition maxColumnVp = this.getMaxColumnInsideRange(selectionStartOffset, selectionEndOffset);
                Point maxColumnsPoint = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(maxColumnVp);
                Point selectionStart = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(selectionStartOffset));
                Point selectionEnd = FragmentCodeStyleSettingsDialog.this.myEditor.visualPositionToXY(FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(selectionEndOffset));
                selectionStart = SwingUtilities.convertPoint(this.myContentComponent, selectionStart, this.myEditorComponent);
                selectionEnd = SwingUtilities.convertPoint(this.myContentComponent, selectionEnd, this.myEditorComponent);
                maxColumnsPoint = SwingUtilities.convertPoint(this.myContentComponent, maxColumnsPoint, this.myEditorComponent);
                this.mySelectionStartY = selectionStart.y;
                this.mySelectionEndY = selectionEnd.y;
                this.myTextRangeMaxColumnX = maxColumnsPoint.x;
            }

            private VisualPosition getMaxColumnInsideRange(int startOffset, int endOffset) {
                int firstLine = FragmentCodeStyleSettingsDialog.this.myDocument.getLineNumber(startOffset);
                int lastLine = FragmentCodeStyleSettingsDialog.this.myDocument.getLineNumber(endOffset);
                VisualPosition positionWithMaxColumn = new VisualPosition(0, 0);
                for (int currentLine = firstLine; currentLine <= lastLine; ++currentLine) {
                    int offset = FragmentCodeStyleSettingsDialog.this.myDocument.getLineEndOffset(currentLine);
                    VisualPosition position = FragmentCodeStyleSettingsDialog.this.myEditor.offsetToVisualPosition(offset);
                    if (position.getColumn() <= positionWithMaxColumn.getColumn()) continue;
                    positionWithMaxColumn = position;
                }
                return positionWithMaxColumn;
            }
        }
    }
}

