/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FTPExtendedClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class FtpClientFactory {
    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FtpConnectionFactory factory = new FtpConnectionFactory(FtpFileSystemConfigBuilder.getInstance());
        return factory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions);
    }

    public static abstract class ConnectionFactory<C extends FTPClient, B extends FtpFileSystemConfigBuilder> {
        private static final char[] ANON_CHAR_ARRAY = "anonymous".toCharArray();
        private static final int BUFSZ = 40;
        private static final Log log = LogFactory.getLog((String)"#com.jetbrains.plugins.webDeployment.ftp");
        protected B builder;

        protected ConnectionFactory(B builder) {
            this.builder = builder;
        }

        public C createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
            if (username == null) {
                username = ANON_CHAR_ARRAY;
            }
            if (password == null) {
                password = ANON_CHAR_ARRAY;
            }
            try {
                Boolean remoteVerification;
                Integer keepAliveTimeout;
                ServerSocketFactory serverSocketFactory;
                SocketFactory socketFactory;
                C client = this.createClient(fileSystemOptions);
                if (log.isDebugEnabled()) {
                    StringWriter writer = new StringWriter(1024){

                        @Override
                        public void flush() {
                            StringBuffer buffer = this.getBuffer();
                            String message = buffer.toString();
                            if (message.toUpperCase().startsWith("PASS ") && message.length() > 5) {
                                message = "PASS ***";
                            }
                            ConnectionFactory.log(message);
                            buffer.setLength(0);
                        }
                    };
                    client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(writer)));
                }
                client.setListHiddenFiles(((FtpFileSystemConfigBuilder)this.builder).isShowHiddenFiles(fileSystemOptions));
                String homeFolderOverride = ((FtpFileSystemConfigBuilder)this.builder).getHomeFolderOverride(fileSystemOptions);
                if (homeFolderOverride != null) {
                    workingDirectory = homeFolderOverride;
                }
                if ((socketFactory = ((FtpFileSystemConfigBuilder)this.builder).getSocketFactory(fileSystemOptions)) != null) {
                    client.setSocketFactory(socketFactory);
                }
                if ((serverSocketFactory = ((FtpFileSystemConfigBuilder)this.builder).getServerSocketFactory(fileSystemOptions)) != null) {
                    client.setServerSocketFactory(serverSocketFactory);
                }
                if ((keepAliveTimeout = ((FtpFileSystemConfigBuilder)this.builder).getKeepAliveTimeout(fileSystemOptions)) != null && keepAliveTimeout > 999) {
                    client.setControlKeepAliveTimeout((long)(keepAliveTimeout / 1000));
                }
                this.configureClient(fileSystemOptions, client);
                FTPFileEntryParserFactory myFactory = ((FtpFileSystemConfigBuilder)this.builder).getEntryParserFactory(fileSystemOptions);
                if (myFactory != null) {
                    client.setParserFactory(myFactory);
                }
                if ((remoteVerification = ((FtpFileSystemConfigBuilder)this.builder).getRemoteVerification(fileSystemOptions)) != null) {
                    client.setRemoteVerificationEnabled(remoteVerification.booleanValue());
                }
                try {
                    Proxy proxy;
                    String controlEncoding;
                    Integer socketTimeout;
                    Integer connectTimeout = ((FtpFileSystemConfigBuilder)this.builder).getConnectTimeout(fileSystemOptions);
                    if (connectTimeout != null) {
                        client.setConnectTimeout(connectTimeout.intValue());
                    }
                    if ((socketTimeout = ((FtpFileSystemConfigBuilder)this.builder).getSoTimeout(fileSystemOptions)) != null) {
                        client.setDefaultTimeout(socketTimeout.intValue());
                    }
                    if ((controlEncoding = ((FtpFileSystemConfigBuilder)this.builder).getControlEncoding(fileSystemOptions)) != null) {
                        client.setControlEncoding(controlEncoding);
                    }
                    if ((proxy = ((FtpFileSystemConfigBuilder)this.builder).getProxy(fileSystemOptions)) != null) {
                        client.setProxy(proxy);
                    }
                    client.connect(hostname, port);
                    int reply = client.getReplyCode();
                    if (!FTPReply.isPositiveCompletion((int)reply)) {
                        throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", (Object)hostname);
                    }
                    if (!client.login(UserAuthenticatorUtils.toString(username), UserAuthenticatorUtils.toString(password))) {
                        throw new FileSystemException("vfs.provider.ftp/login.error", hostname, UserAuthenticatorUtils.toString(username));
                    }
                    FtpFileType fileType = ((FtpFileSystemConfigBuilder)this.builder).getFileType(fileSystemOptions);
                    if (fileType == null) {
                        fileType = FtpFileType.BINARY;
                    }
                    if (!client.setFileType(fileType.getValue())) {
                        throw new FileSystemException("vfs.provider.ftp/set-file-type.error", (Object)fileType);
                    }
                    Integer dataTimeout = ((FtpFileSystemConfigBuilder)this.builder).getDataTimeout(fileSystemOptions);
                    if (dataTimeout != null) {
                        client.setDataTimeout(dataTimeout.intValue());
                    }
                    Boolean userDirIsRoot = ((FtpFileSystemConfigBuilder)this.builder).getUserDirIsRoot(fileSystemOptions);
                    if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue() || client.changeWorkingDirectory(workingDirectory))) {
                        throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", (Object)workingDirectory);
                    }
                    Boolean passiveMode = ((FtpFileSystemConfigBuilder)this.builder).getPassiveMode(fileSystemOptions);
                    if (passiveMode != null && passiveMode.booleanValue()) {
                        client.enterLocalPassiveMode();
                    }
                    this.setupOpenConnection(client, fileSystemOptions);
                }
                catch (IOException e) {
                    if (client.isConnected()) {
                        client.disconnect();
                    }
                    throw e;
                }
                return client;
            }
            catch (Exception exc) {
                throw new FileSystemException(this.getConnectionExceptionMessage(), (Throwable)exc, hostname);
            }
        }

        protected String getConnectionExceptionMessage() {
            return "vfs.provider.ftp/connect.error";
        }

        protected abstract C createClient(FileSystemOptions var1) throws FileSystemException;

        protected abstract void setupOpenConnection(C var1, FileSystemOptions var2) throws IOException;

        private void configureClient(FileSystemOptions fileSystemOptions, C client) {
            String key = ((FtpFileSystemConfigBuilder)this.builder).getEntryParser(fileSystemOptions);
            if (key != null) {
                String[] shortMonthNames;
                String serverTimeZoneId;
                String recentDateFormat;
                String defaultDateFormat;
                FTPClientConfig config = new FTPClientConfig(key);
                String serverLanguageCode = ((FtpFileSystemConfigBuilder)this.builder).getServerLanguageCode(fileSystemOptions);
                if (serverLanguageCode != null) {
                    config.setServerLanguageCode(serverLanguageCode);
                }
                if ((defaultDateFormat = ((FtpFileSystemConfigBuilder)this.builder).getDefaultDateFormat(fileSystemOptions)) != null) {
                    config.setDefaultDateFormatStr(defaultDateFormat);
                }
                if ((recentDateFormat = ((FtpFileSystemConfigBuilder)this.builder).getRecentDateFormat(fileSystemOptions)) != null) {
                    config.setRecentDateFormatStr(recentDateFormat);
                }
                if ((serverTimeZoneId = ((FtpFileSystemConfigBuilder)this.builder).getServerTimeZoneId(fileSystemOptions)) != null) {
                    config.setServerTimeZoneId(serverTimeZoneId);
                }
                if ((shortMonthNames = ((FtpFileSystemConfigBuilder)this.builder).getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuilder shortMonthNamesStr = new StringBuilder(40);
                    for (String shortMonthName : shortMonthNames) {
                        if (shortMonthNamesStr.length() > 0) {
                            shortMonthNamesStr.append("|");
                        }
                        shortMonthNamesStr.append(shortMonthName);
                    }
                    config.setShortMonthNames(shortMonthNamesStr.toString());
                }
                client.configure(config);
            }
        }

        private static void log(String text) {
            if (text.endsWith("\r\n")) {
                text = text.substring(0, text.lastIndexOf("\r\n"));
            }
            log.debug((Object)text);
        }
    }

    public static class FtpConnectionFactory
    extends ConnectionFactory<FTPClient, FtpFileSystemConfigBuilder> {
        private FtpConnectionFactory(FtpFileSystemConfigBuilder builder) {
            super(builder);
        }

        @Override
        protected FTPClient createClient(FileSystemOptions fileSystemOptions) {
            return new FTPExtendedClient();
        }

        @Override
        protected void setupOpenConnection(FTPClient client, FileSystemOptions fileSystemOptions) {
        }
    }
}

