/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.AttributeType;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

final class SafeStAXStreamBuilder {
    private static final JDOMFactory factory = new DefaultJDOMFactory();

    SafeStAXStreamBuilder() {
    }

    static Document buildDocument(@NotNull XMLStreamReader stream, boolean isIgnoreBoundaryWhitespace) throws JDOMException, XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(0);
        }
        if (7 != (state = stream.getEventType())) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = factory.document(null);
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", (Object)stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", (Object)String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", (Object)stream.getEncoding());
                    break;
                }
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace));
                    break;
                }
                case 2: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: END_ELEMENT");
                }
                case 9: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: ENTITY_REFERENCE");
                }
                case 12: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: CDATA");
                }
                case 6: {
                    document.addContent((Content)factory.text(stream.getText()));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace((String)badTxt)) break;
                    throw new JDOMException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ")");
                }
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new JDOMException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    static Element build(@NotNull XMLStreamReader stream, boolean isIgnoreBoundaryWhitespace) throws JDOMException, XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(1);
        }
        if (7 != (state = stream.getEventType())) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 7: {
                    break;
                }
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace);
                    break;
                }
                case 2: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: END_ELEMENT");
                }
                case 9: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: ENTITY_REFERENCE");
                }
                case 12: {
                    throw new JDOMException("Unexpected XMLStream event at Document level: CDATA");
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new JDOMException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    private static Element processElementFragment(@NotNull XMLStreamReader reader, boolean isIgnoreBoundaryWhitespace) throws XMLStreamException, JDOMException {
        Element fragment;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(2);
        }
        if (reader.getEventType() != 1) {
            throw new JDOMException("JDOM requires that the XMLStreamReader is at the START_ELEMENT state when retrieving an Element Fragment.");
        }
        Element current = fragment = SafeStAXStreamBuilder.processElement(reader);
        int depth = 1;
        block9: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilder.processElement(reader);
                    current.addContent(tmp);
                    current = tmp;
                    ++depth;
                    continue block9;
                }
                case 2: {
                    current = current.getParentElement();
                    --depth;
                    continue block9;
                }
                case 12: {
                    current.addContent((Content)factory.cdata(reader.getText()));
                    continue block9;
                }
                case 6: {
                    if (!isIgnoreBoundaryWhitespace) {
                        current.addContent((Content)factory.text(reader.getText()));
                    }
                }
                case 4: {
                    if (isIgnoreBoundaryWhitespace && reader.isWhiteSpace()) continue block9;
                    current.addContent((Content)factory.text(reader.getText()));
                    continue block9;
                }
                case 9: {
                    current.addContent((Content)factory.entityRef(reader.getLocalName()));
                    continue block9;
                }
                case 3: 
                case 5: {
                    continue block9;
                }
            }
            throw new JDOMException("Unexpected XMLStream event " + reader.getEventType());
        }
        return fragment;
    }

    @NotNull
    private static Element processElement(@NotNull XMLStreamReader reader) {
        int i;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(3);
        }
        Element element = factory.element(reader.getLocalName(), Namespace.getNamespace((String)reader.getPrefix(), (String)reader.getNamespaceURI()));
        int len = reader.getAttributeCount();
        for (i = 0; i < len; ++i) {
            factory.setAttribute(element, factory.attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i), AttributeType.getAttributeType((String)reader.getAttributeType(i)), Namespace.getNamespace((String)reader.getAttributePrefix(i), (String)reader.getAttributeNamespace(i))));
        }
        len = reader.getNamespaceCount();
        for (i = 0; i < len; ++i) {
            element.addNamespaceDeclaration(Namespace.getNamespace((String)reader.getNamespacePrefix(i), (String)reader.getNamespaceURI(i)));
        }
        Element element2 = element;
        if (element2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(4);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processElementFragment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

