/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.proxy;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.proxy.DBGPProxySettings;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DBGPProxyConfigurable
implements SearchableConfigurable,
Configurable {
    private static final String DISPLAY_NAME = PhpBundle.message("DBGPProxyConfigurable.display.name", new Object[0]);
    private static final String HELP_ID = "reference.settings.php.debug.xdebug.proxy";
    private JPanel myMainPanel;
    private JTextField myHostTextField;
    private JTextField myPortTextField;
    private JTextField myIdeKeyTextField;
    private final Project myProject;
    private final boolean myStrictValidation;

    public DBGPProxyConfigurable(@NotNull Project project) {
        if (project == null) {
            DBGPProxyConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public DBGPProxyConfigurable(@NotNull Project project, boolean strictValidation) {
        if (project == null) {
            DBGPProxyConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myStrictValidation = strictValidation;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return HELP_ID;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        DBGPProxySettings.State proxySettings = DBGPProxySettings.getInstance(this.myProject).getState();
        if (!this.myIdeKeyTextField.getText().equals(StringUtil.notNullize((String)proxySettings.getIdeKey()))) {
            return true;
        }
        if (!this.myHostTextField.getText().equals(StringUtil.notNullize((String)proxySettings.getProxyHost()))) {
            return true;
        }
        return PhpUiUtil.getIntValue(this.myPortTextField.getText()) != proxySettings.getProxyPort();
    }

    public void apply() throws ConfigurationException {
        DBGPProxySettings.State proxySettings = DBGPProxySettings.getInstance(this.myProject).getState();
        DBGPProxyConfigurable.validate(this.myIdeKeyTextField.getText(), this.myHostTextField.getText(), this.myPortTextField.getText(), this.myStrictValidation);
        proxySettings.setIdeKey(this.myIdeKeyTextField.getText());
        proxySettings.setProxyHost(this.myHostTextField.getText());
        proxySettings.setProxyPort(PhpUiUtil.getIntValue(this.myPortTextField.getText()));
    }

    public static void validate(@NotNull Project project, boolean strictValidation) throws ConfigurationException {
        if (project == null) {
            DBGPProxyConfigurable.$$$reportNull$$$0(2);
        }
        DBGPProxySettings.State proxySettings = DBGPProxySettings.getInstance(project).getState();
        DBGPProxyConfigurable.validate(proxySettings.getIdeKey(), proxySettings.getProxyHost(), String.valueOf(proxySettings.getProxyPort()), strictValidation);
    }

    public static void validate(@Nullable String ideKey, @Nullable String host, @NotNull String port, boolean strictValidation) throws ConfigurationException {
        int proxyPort;
        if (port == null) {
            DBGPProxyConfigurable.$$$reportNull$$$0(3);
        }
        if (strictValidation) {
            if (StringUtil.isEmptyOrSpaces((String)ideKey)) {
                throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("dbgp.proxy.ide.key", new Object[0])));
            }
            if (StringUtil.isEmptyOrSpaces((String)host)) {
                throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("dbgp.proxy.host", new Object[0])));
            }
        }
        if ((proxyPort = PhpUiUtil.getIntValue(port)) < 0) {
            throw new ConfigurationException(PhpBundle.message("validation.value.is.invalid", PhpBundle.message("dbgp.proxy.port", new Object[0])));
        }
    }

    public void reset() {
        DBGPProxySettings.State proxySettings = DBGPProxySettings.getInstance(this.myProject).getState();
        this.myIdeKeyTextField.setText(proxySettings.getIdeKey());
        this.myHostTextField.setText(proxySettings.getProxyHost());
        this.myPortTextField.setText(String.valueOf(proxySettings.getProxyPort()));
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            DBGPProxyConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/proxy/DBGPProxyConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/proxy/DBGPProxyConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("DBGPProxyConfigurable.ide.key"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/PhpBundle").getString("DBGPProxyConfigurable.host"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("DBGPProxyConfigurable.port"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIdeKeyTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(100, -1), null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(100, -1), null));
        this.myPortTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(70, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

