/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="CommandLine")
public class PhpCommandLineSettings
implements Cloneable {
    private String myWorkingDirectory = null;
    private String myParameters = null;
    @NotNull
    private Map<String, String> myEnvs = new HashMap<String, String>();
    private boolean myPassParentEnvs = true;

    @Transient
    @Nullable
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(0);
        }
        this.myWorkingDirectory = StringUtil.nullize((String)workingDirectory);
    }

    @Attribute(value="workingDirectory")
    @Nullable
    public String getSerializedWorkingDirectory() {
        return PhpConfigurationUtil.serializePath(this.myWorkingDirectory);
    }

    public void setSerializedWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = PhpConfigurationUtil.deserializePath(workingDirectory);
    }

    @Attribute(value="parameters")
    @Nullable
    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(@NotNull String parameters) {
        if (parameters == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(1);
        }
        this.myParameters = StringUtil.nullize((String)parameters);
    }

    @Tag(value="envs")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="env", keyAttributeName="name", valueAttributeName="value")
    @NotNull
    public Map<String, String> getSerializedEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(2);
        }
        return map;
    }

    public void setSerializedEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(3);
        }
        this.myEnvs = envs;
    }

    @Transient
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(5);
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    @Attribute(value="pass_parent_envs")
    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpCommandLineSettings that = (PhpCommandLineSettings)o;
        if (this.myPassParentEnvs != that.myPassParentEnvs) {
            return false;
        }
        if (!this.myEnvs.equals(that.myEnvs)) {
            return false;
        }
        if (this.myParameters != null ? !this.myParameters.equals(that.myParameters) : that.myParameters != null) {
            return false;
        }
        return !(this.myWorkingDirectory != null ? !this.myWorkingDirectory.equals(that.myWorkingDirectory) : that.myWorkingDirectory != null);
    }

    public int hashCode() {
        int result = this.myWorkingDirectory != null ? this.myWorkingDirectory.hashCode() : 0;
        result = 31 * result + (this.myParameters != null ? this.myParameters.hashCode() : 0);
        result = 31 * result + this.myEnvs.hashCode();
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        return result;
    }

    public PhpCommandLineSettings clone() {
        PhpCommandLineSettings commandLineSettings = new PhpCommandLineSettings();
        if (StringUtil.isNotEmpty((String)this.myWorkingDirectory)) {
            commandLineSettings.setWorkingDirectory(this.myWorkingDirectory);
        }
        if (StringUtil.isNotEmpty((String)this.myParameters)) {
            commandLineSettings.setParameters(this.myParameters);
        }
        if (!this.myEnvs.isEmpty()) {
            HashMap<String, String> envs = new HashMap<String, String>();
            for (Map.Entry<String, String> env : this.myEnvs.entrySet()) {
                envs.put(env.getKey(), env.getValue());
            }
            commandLineSettings.setEnvs(envs);
        }
        commandLineSettings.setPassParentEnvs(this.myPassParentEnvs);
        return commandLineSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpCommandLineSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpCommandLineSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedEnvs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSerializedEnvs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

