/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.edit;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.SmartyFileType;
import com.jetbrains.smarty.SmartyLanguage;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartyTagsMatcher
implements BraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(SmartyTokenTypes.L_BRACKET, SmartyTokenTypes.R_BRACKET, false), new BracePair(SmartyTokenTypes.L_PAR, SmartyTokenTypes.R_PAR, false)};

    public int getBraceTokenGroupId(IElementType tokenType) {
        Language l = tokenType.getLanguage();
        return l.hashCode();
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs = matcher.getPairs();
            BracePair[] bracePairArray = pairs;
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getLeftBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)SmartyLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != SmartyFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isLBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? StdFileTypes.HTML : tokenFileType));
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() != tokenType) continue;
            return true;
        }
        return tokenType == SmartyTokenTypes.START_TAG_START;
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType = iterator.getTokenType();
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType.getLanguage());
        if (matcher != null) {
            BracePair[] pairs = matcher.getPairs();
            for (BracePair pair : pairs) {
                if (pair.getRightBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)SmartyLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != SmartyFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isRBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? StdFileTypes.HTML : tokenFileType));
            }
        }
        if (tokenType == SmartyTokenTypes.SHARP) {
            iterator.retreat();
            IElementType nextTokenType = iterator.getTokenType();
            iterator.advance();
            return nextTokenType == SmartyTokenTypes.IDENTIFIER;
        }
        for (IElementType pair : PAIRS) {
            if (pair.getRightBraceType() != tokenType) continue;
            return true;
        }
        if (tokenType != SmartyTokenTypes.TAG_END) {
            return false;
        }
        int iteratorBackwardOffset = 0;
        while (!iterator.atEnd() && iterator.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION && iterator.getTokenType() != SmartyTokenTypes.START_TAG_START) {
            iterator.retreat();
            ++iteratorBackwardOffset;
        }
        if (!iterator.atEnd() && iterator.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            this.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return true;
        }
        if (iterator.atEnd() || iterator.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION) {
            this.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return false;
        }
        String functionName = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
        if (SmartyCompletionContributor.isUnique(functionName)) {
            this.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return true;
        }
        iterator.retreat();
        ++iteratorBackwardOffset;
        while (!iterator.atEnd() && iterator.getTokenType() == SmartyTokenTypes.WHITE_SPACE) {
            iterator.retreat();
            ++iteratorBackwardOffset;
        }
        boolean returnValue = iterator.getTokenType() == SmartyTokenTypes.END_TAG_START;
        this.returnIteratorBack(iterator, -iteratorBackwardOffset);
        return returnValue;
    }

    private void returnIteratorBack(HighlighterIterator iterator, int offset) {
        while (offset != 0) {
            if (offset < 0) {
                iterator.advance();
                ++offset;
                continue;
            }
            iterator.retreat();
            --offset;
        }
    }

    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType1.getLanguage());
        if (matcher != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() == tokenType1) {
                    return pair.getRightBraceType() == tokenType2;
                }
                if (pair.getRightBraceType() != tokenType1) continue;
                return pair.getLeftBraceType() == tokenType2;
            }
        }
        LanguageFileType tokenFileType1 = tokenType1.getLanguage().getAssociatedFileType();
        LanguageFileType tokenFileType2 = tokenType2.getLanguage().getAssociatedFileType();
        if (tokenFileType2 != tokenFileType1) {
            return false;
        }
        if (tokenFileType1 != SmartyFileType.INSTANCE && tokenFileType1 != null) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (!ext.filetype.equals(tokenFileType1.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isPairBraces(tokenType1, tokenType2);
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == tokenType1) {
                return pair.getRightBraceType() == tokenType2;
            }
            if (pair.getRightBraceType() != tokenType1) continue;
            return pair.getLeftBraceType() == tokenType2;
        }
        return tokenType1 == SmartyTokenTypes.START_TAG_START && tokenType2 == SmartyTokenTypes.TAG_END || tokenType1 == SmartyTokenTypes.TAG_END && tokenType2 == SmartyTokenTypes.START_TAG_START;
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        return true;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        PairedBraceMatcher matcher;
        if (type == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(0);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(type.getLanguage())) != null) {
            BracePair[] pairs;
            BracePair[] bracePairArray = pairs = matcher.getPairs();
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getLeftBraceType() == type) {
                    return pair.getRightBraceType();
                }
                if (pair.getRightBraceType() != type) continue;
                return pair.getLeftBraceType();
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == type) {
                return pair.getRightBraceType();
            }
            if (pair.getRightBraceType() != type) continue;
            return pair.getLeftBraceType();
        }
        if (type == SmartyTokenTypes.START_TAG_START) {
            return SmartyTokenTypes.TAG_END;
        }
        if (type == SmartyTokenTypes.TAG_END) {
            return SmartyTokenTypes.START_TAG_START;
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(1);
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/smarty/edit/SmartyTagsMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

