/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import a.b.lb;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesIndex;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesForm;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class DuplocateManager {
    private static final Logger b;
    private final Project a;
    private ContentManager c;
    private static final long d;

    public DuplocateManager(Project p2) {
        this.a = p2;
        StartupManager.getInstance((Project)p2).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.a);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.DUPLICATES, true, ToolWindowAnchor.BOTTOM, (Disposable)p2);
            this.c = toolWindow.getContentManager();
            new ContentManagerWatcher(toolWindow, this.c);
        });
    }

    public static DuplocateManager getInstance(Project p2) {
        return (DuplocateManager)ServiceManager.getService((Project)p2, DuplocateManager.class);
    }

    private static DuplocateVisitor[] a(DuplicatesProfile[] duplicatesProfileArray, FragmentsCollector fragmentsCollector, DuplocatorSettings duplocatorSettings) {
        DuplocatorSettings.getInstance().loadState(duplocatorSettings);
        DuplocateVisitor[] duplocateVisitorArray = new DuplocateVisitor[duplicatesProfileArray.length];
        for (int i10 = 0; i10 < duplocateVisitorArray.length; ++i10) {
            duplocateVisitorArray[i10] = duplicatesProfileArray[i10].createVisitor(fragmentsCollector);
        }
        return duplocateVisitorArray;
    }

    public static void hash(DuplocatorHashCallback duplicateCollector, DuplocatorSettings settings, AnalysisScope scope) {
        DuplicatesProfile duplicatesProfile;
        long l3 = d ^ 0xDC2F4B2A1A4L;
        Language language = Language.findLanguageByID((String)"JAVA");
        if (language != null && (duplicatesProfile = DuplicatesProfile.findProfileForLanguage(language)) != null) {
            DuplocateManager.hash(null, scope, duplicateCollector, Collections.singletonList(duplicatesProfile), settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void hash(@Nullable Project project, AnalysisScope scope, FragmentsCollector collector, List<? extends DuplicatesProfile> profiles, DuplocatorSettings settings) {
        DuplicatesProfile[] duplicatesProfileArray;
        long l3 = d ^ 0x151F1EA1111AL;
        ArrayList<DuplicatesProfile> arrayList = new ArrayList<DuplicatesProfile>();
        ArrayList<DuplicatesProfile> arrayList2 = new ArrayList<DuplicatesProfile>();
        boolean bl2 = scope.getFileCount() > 500;
        for (DuplicatesProfile object : profiles) {
            if (bl2 && project != null && object.supportIndex()) {
                arrayList.add(object);
                continue;
            }
            arrayList2.add(object);
        }
        if (arrayList.size() > 0) {
            void var11_13;
            duplicatesProfileArray = arrayList.toArray(new DuplicatesProfile[0]);
            try {
                assert (project != null);
                DuplicatesIndex duplicatesIndex = new DuplicatesIndex(project, duplicatesProfileArray);
            }
            catch (IOException iOException) {
                b.warn("Duplicates index cannot be used", (Throwable)iOException);
                Object var11_12 = null;
            }
            if (var11_13 != null) {
                try {
                    var11_13.update(scope);
                    var11_13.processAll(scope, collector);
                }
                finally {
                    Disposer.dispose((Disposable)var11_13);
                }
            } else {
                arrayList2.addAll(arrayList);
            }
        }
        if (arrayList2.size() > 0) {
            duplicatesProfileArray = arrayList2.toArray(new DuplicatesProfile[0]);
            DuplocateManager.doHash(scope, collector, duplicatesProfileArray, settings);
        }
    }

    public static void doHash(AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        DuplocateVisitor[] duplocateVisitorArray;
        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray = DuplocateManager.a(scope, collector, profiles, settings)) {
            duplocateVisitor.hashingFinished();
        }
    }

    private static DuplocateVisitor[] a(AnalysisScope analysisScope, FragmentsCollector fragmentsCollector, DuplicatesProfile[] duplicatesProfileArray, DuplocatorSettings duplocatorSettings) {
        long l3 = d ^ 0x1F15E954E9D8L;
        final int n2 = analysisScope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final int[] nArray = new int[]{0};
        if (progressIndicator != null) {
            progressIndicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
        }
        final DuplocateVisitor[] duplocateVisitorArray = DuplocateManager.a(duplicatesProfileArray, fragmentsCollector, duplocatorSettings);
        analysisScope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitFile(PsiFile baseFile) {
                Project project = baseFile.getProject();
                nArray[0] = nArray[0] + 1;
                if (progressIndicator != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                    progressIndicator.setFraction((double)nArray[0] / (double)n2);
                }
                try {
                    for (PsiFile psiFile : baseFile.getViewProvider().getAllFiles()) {
                        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                            duplocateVisitor.visitNode((PsiElement)psiFile);
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        psiManager.dropResolveCaches();
                        InjectedLanguageManager.getInstance((Project)project).dropFileCaches(psiFile);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw processCanceledException;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw indexNotReadyException;
                }
                catch (Exception exception) {
                    b.error((Throwable)exception);
                }
            }
        });
        return duplocateVisitorArray;
    }

    public void findAndShow(AnalysisScope scope, DuplocatorSettings settings, List<DuplicatesProfile> profiles) {
        long l3 = d ^ 0x46BB4E9CDC0FL;
        PsiDocumentManager.getInstance((Project)this.a).commitAllDocuments();
        DuplocatorHashCallback duplocatorHashCallback = new DuplocatorHashCallback(-1, -1);
        Runnable runnable = () -> {
            long l3 = d ^ 0x72804AEF1FF8L;
            try {
                DuplocateManager.hash(this.a, scope, duplocatorHashCallback, profiles, settings);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                DumbService.getInstance((Project)this.a).showDumbModeNotification("Analyze duplicates is not available until indices are ready");
                throw new ProcessCanceledException();
            }
        };
        Runnable runnable2 = () -> ApplicationManager.getApplication().invokeLater(() -> {
            long l3 = d ^ 0x747A2868443AL;
            DupInfo dupInfo = duplocatorHashCallback.getInfo();
            if (dupInfo.getPatterns() > 0) {
                this.showDuplicates(dupInfo, scope, settings, profiles);
            } else {
                Messages.showInfoMessage((Project)this.a, (String)DupLocatorBundle.message("duplication.none.found.message", new Object[0]), (String)DupLocatorBundle.message("duplication.none.found.title", new Object[0]));
            }
        });
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.a, DupLocatorBundle.message("duplication.progress", new Object[0]), runnable, runnable2, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.a));
    }

    public void showDuplicates(DupInfo info, AnalysisScope scope, DuplocatorSettings settings) {
        int n2 = -1;
        this.showDuplicates(info, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", DuplicatesProfile.getAllProfiles());
    }

    public void showDuplicates(DupInfo info, int caretOffset, VirtualFile virtualFile, String title) {
        this.showDuplicates(info, null, null, caretOffset, virtualFile, title, DuplicatesProfile.getAllProfiles());
    }

    public void showDuplicates(DupInfo duplicates, AnalysisScope scope, DuplocatorSettings settings, List<DuplicatesProfile> profiles) {
        int n2 = -1;
        this.showDuplicates(duplicates, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", profiles);
    }

    public void showDuplicates(DupInfo duplicates, AnalysisScope scope, DuplocatorSettings settings, int caretOffset, VirtualFile virtualFile, String title, List<DuplicatesProfile> profiles) {
        Object object;
        long l3 = d ^ 0x5FDDD7437A42L;
        DuplicatesForm duplicatesForm = DuplicatesForm.create(this.a, duplicates);
        if (caretOffset != -1 && virtualFile != null) {
            object = duplicatesForm.getDuplicatesTree();
            TreeUtil.traverse((TreeNode)((TreeNode)((JTree)object).getModel().getRoot()), arg_0 -> DuplocateManager.a(virtualFile, caretOffset, (JTree)object, arg_0));
        }
        object = new ContentPanel(duplicatesForm.getComponent());
        if (scope != null && profiles != null) {
            ((ContentPanel)object).addRerunAction(() -> {
                Content content = this.c.getSelectedContent();
                if (content != null) {
                    this.c.removeContent(content, true);
                }
                this.findAndShow(scope, settings, profiles);
            });
        }
        Content content = this.c.getFactory().createContent((JComponent)((ContentPanel)object).getComponent(), title, true);
        content.setHelpId("find.locateDuplicates.result");
        content.setDisposer((Disposable)duplicatesForm);
        this.c.addContent(content);
        this.c.setSelectedContent(content);
        ((ContentPanel)object).addCloseAction(this.c, content);
        duplicatesForm.addToolbarActionsTo((ContentPanel)object);
        ToolWindowManager.getInstance((Project)this.a).getToolWindow(ToolWindowId.DUPLICATES).activate(null);
    }

    private static /* synthetic */ boolean a(VirtualFile virtualFile, int n2, JTree jTree, Object object) {
        if (object instanceof CodeNode) {
            CodeNode codeNode = (CodeNode)object;
            try {
                if (Comparing.equal((Object)codeNode.getVirtualFile(), (Object)virtualFile) && codeNode.getTextRange().contains(n2)) {
                    TreeUtil.selectNode((JTree)jTree, (TreeNode)codeNode);
                    return false;
                }
            }
            catch (InvalidatedException invalidatedException) {
                return true;
            }
        }
        return true;
    }

    static {
        d = lb.a(-2696302741772048849L, 3839143167857952269L, MethodHandles.lookup().lookupClass()).a(128950078678099L);
        long l3 = d ^ 0x2C8C73A76C25L;
        b = Logger.getInstance((String)"#com.intellij.dupLocator.DuplocateManager");
    }
}

