/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.common.NumberHelper;

final class MpdResultSetRow
extends MapRow {
    public MpdResultSetRow(ResultSet resultSet, Map<String, Integer> map) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Object object;
            String string = entry.getKey().toUpperCase();
            int n = entry.getValue();
            switch (n) {
                case -7: 
                case 16: {
                    object = resultSet.getBoolean(string);
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    object = resultSet.getString(string);
                    break;
                }
                case 91: {
                    object = resultSet.getDate(string);
                    break;
                }
                case 93: {
                    Timestamp timestamp = resultSet.getTimestamp(string);
                    if (timestamp != null) {
                        object = new Date(timestamp.getTime());
                        break;
                    }
                    object = null;
                    break;
                }
                case 2: 
                case 8: {
                    object = NumberHelper.getDouble(resultSet.getDouble(string));
                    break;
                }
                case 4: 
                case 5: {
                    object = resultSet.getInt(string);
                    break;
                }
                case -5: {
                    object = resultSet.getLong(string);
                    break;
                }
                case -4: 
                case -3: {
                    object = resultSet.getBytes(string);
                    break;
                }
                case 1111: {
                    object = resultSet.getObject(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + n + " for column " + string);
                }
            }
            if (resultSet.wasNull()) {
                object = null;
            }
            this.m_map.put(string, object);
        }
    }
}

