/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Type[] getElementTypes(TypeToken<?> typeToken, Class<?> targetType) {
        return TypeUtils.getElementTypes(typeToken.getType(), typeToken.getRawType(), targetType);
    }

    private static Type[] getElementTypes(Type type, Class<?> rawType, Class<?> targetType) {
        Class<?> rawSupertype;
        if (targetType.equals(rawType) && type instanceof ParameterizedType) {
            Type mappedType = type instanceof ParameterizedTypeImpl ? type : TypeUtils.getMappedType(type, Collections.emptyMap());
            return ((ParameterizedType)mappedType).getActualTypeArguments();
        }
        Map<String, Type> varMapping = TypeUtils.createVariableMapping(type, rawType);
        if (targetType.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Collection.class.isAssignableFrom(interfaces[i])) continue;
                Type genericInterface = rawType.getGenericInterfaces()[i];
                Type mappedInterface = TypeUtils.getMappedType(genericInterface, varMapping);
                return TypeUtils.getElementTypes(mappedInterface, interfaces[i], targetType);
            }
        }
        if (!rawType.isInterface() && targetType.isAssignableFrom(rawSupertype = rawType.getSuperclass())) {
            Type genericSuperclass = rawType.getGenericSuperclass();
            Type mappedSuperclass = TypeUtils.getMappedType(genericSuperclass, varMapping);
            return TypeUtils.getElementTypes(mappedSuperclass, rawSupertype, targetType);
        }
        Object[] result = new Type[targetType.getTypeParameters().length];
        Arrays.fill(result, Object.class);
        return result;
    }

    private static <T> Map<String, Type> createVariableMapping(Type type, Class<T> rawType) {
        if (type instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            HashMap<String, Type> newVarMapping = new HashMap<String, Type>(TypeUtils.capacity(vars.length));
            for (int i = 0; i < vars.length; ++i) {
                Object actualType = Object.class;
                if (i < args.length && (actualType = args[i]) instanceof WildcardType) {
                    actualType = ((WildcardType)actualType).getUpperBounds()[0];
                }
                newVarMapping.put(vars[i].getName(), (Type)actualType);
            }
            return newVarMapping;
        }
        return Collections.emptyMap();
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return expectedSize + expectedSize / 3;
    }

    private static Type getMappedType(Type type, Map<String, Type> varMapping) {
        String name;
        if (type instanceof TypeVariable && varMapping.containsKey(name = ((TypeVariable)type).getName())) {
            return varMapping.get(name);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.getMappedType(((WildcardType)type).getUpperBounds()[0], varMapping);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] origArgs = pt.getActualTypeArguments();
            Type[] mappedArgs = new Type[origArgs.length];
            for (int i = 0; i < origArgs.length; ++i) {
                mappedArgs[i] = TypeUtils.getMappedType(origArgs[i], varMapping);
            }
            return new ParameterizedTypeImpl(pt, mappedArgs);
        }
        return type;
    }

    public static Collection<Type> getExpectedTypes(Type type) {
        ArrayList<Type> result = new ArrayList<Type>();
        TypeUtils.collectExpectedTypes(type, result);
        return result;
    }

    private static void collectExpectedTypes(Type type, Collection<Type> types) {
        if (TypeUtils.isEither(type)) {
            if (type instanceof ParameterizedType) {
                for (Type type2 : ((ParameterizedType)type).getActualTypeArguments()) {
                    TypeUtils.collectExpectedTypes(type2, types);
                }
            }
            if (type instanceof Class) {
                for (Type type3 : ((Class)type).getTypeParameters()) {
                    TypeUtils.collectExpectedTypes(type3, types);
                }
            }
        } else {
            types.add(type);
        }
    }

    public static boolean isEither(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.isEither(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return Either.class.isAssignableFrom((Class)type);
        }
        return false;
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] actualTypeArguments;

        ParameterizedTypeImpl(ParameterizedType original, Type[] typeArguments) {
            this(original.getOwnerType(), original.getRawType(), typeArguments);
        }

        ParameterizedTypeImpl(Type ownerType, Type rawType, Type[] typeArguments) {
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.actualTypeArguments = typeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.ownerType != null) {
                result.append(this.toString(this.ownerType));
                result.append('$');
            }
            result.append(this.toString(this.rawType));
            result.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.toString(this.actualTypeArguments[i]));
            }
            result.append('>');
            return result.toString();
        }

        private String toString(Type type) {
            if (type instanceof Class) {
                return ((Class)type).getName();
            }
            return String.valueOf(type);
        }
    }
}

