/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class RevisionsList {
    public static final int RECENT_PERIOD = 12;
    private final JBTable table = new JBTable();

    public RevisionsList(SelectionListener l) {
        this.table.setModel((TableModel)new MyModel(Collections.emptyList(), Collections.emptyMap()));
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.resetDefaultFocusTraversalKeys();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new MyCellRenderer(this.table));
        this.table.getEmptyText().setText(VcsBundle.message((String)"history.empty", (Object[])new Object[0]));
        this.addSelectionListener(l);
    }

    public JComponent getComponent() {
        return this.table;
    }

    private void addSelectionListener(SelectionListener listener2) {
        final SelectionListener l = listener2;
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private int mySelectedRow1 = 0;
            private int mySelectedRow2 = 0;
            private final SelectionListener mySelectionListener = l;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = RevisionsList.this.table.getSelectionModel();
                this.mySelectedRow1 = sm.getMinSelectionIndex();
                this.mySelectedRow2 = sm.getMaxSelectionIndex();
                this.mySelectionListener.revisionsSelected(this.mySelectedRow1, this.mySelectedRow2);
            }
        });
    }

    public void updateData(HistoryDialogModel model) {
        int i2;
        THashSet sel = new THashSet();
        MyModel m = (MyModel)this.table.getModel();
        for (int i2 : this.table.getSelectedRows()) {
            if (i2 >= m.getRowCount()) continue;
            sel.add(m.getValueAt((int)i2, (int)0).revision.getChangeSetId());
        }
        List<RevisionItem> newRevs = model.getRevisions();
        Date today = new Date();
        THashMap periods = new THashMap();
        for (i2 = 0; i2 < newRevs.size(); ++i2) {
            boolean recent;
            RevisionItem each = newRevs.get(i2);
            boolean bl = recent = today.getTime() - each.revision.getTimestamp() < 43200000L;
            if (recent) {
                if (i2 != 0) continue;
                periods.put(each, Period.RECENT);
                continue;
            }
            periods.put(each, periods.isEmpty() ? Period.OLD : Period.OLDER);
            break;
        }
        this.table.setModel((TableModel)new MyModel(newRevs, (Map<RevisionItem, Period>)periods));
        for (i2 = 0; i2 < newRevs.size(); ++i2) {
            RevisionItem r = newRevs.get(i2);
            if (!sel.contains(r.revision.getChangeSetId())) continue;
            this.table.getSelectionModel().addSelectionInterval(i2, i2);
        }
        if (this.table.getSelectionModel().isSelectionEmpty()) {
            this.table.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    public static class MyCellRenderer
    implements TableCellRenderer {
        private static final Color USER_LABEL_COLOR = new JBColor(new Color(230, 230, 250), new Color(89, 96, 74));
        private static final Insets BORDER_INSETS = new Insets(2, 5, 2, 5);
        private final DefaultTableCellRenderer myTemplate = new DefaultTableCellRenderer();
        private final MyWrapperPanel myWrapperPanel = new MyWrapperPanel();
        private final JPanel myItemPanel = new JPanel();
        private final MyBorder myBorder = new MyBorder(BORDER_INSETS);
        private final SeparatorWithText myPeriodLabel = new SeparatorWithText();
        private final JBLabel myDateLabel = new JBLabel();
        private final JBLabel myFilesCountLabel = new JBLabel();
        private final JBLabel myTitleLabel = new JBLabel();
        private final JPanel myLabelPanel = new JPanel();
        private final MyLabelContainer myLabelContainer = new MyLabelContainer();
        private final JBLabel myLabelLabel = new JBLabel();
        private final ExpandableItemsHandler<TableCell> myToolTipHandler;

        public MyCellRenderer(JBTable table) {
            this.myToolTipHandler = table.getExpandableItemsHandler();
            JPanel headersPanel = new JPanel(new BorderLayout());
            headersPanel.setOpaque(false);
            headersPanel.add((Component)this.myPeriodLabel, "North");
            headersPanel.add((Component)this.myLabelPanel, "Center");
            this.myLabelContainer.add((Component)this.myLabelLabel);
            this.myLabelPanel.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension size = myLabelContainer.getPreferredSize();
                    JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                    return size;
                }

                public void layoutContainer(Container parent) {
                    Insets i = parent.getInsets();
                    int pw = parent.getWidth() - i.left - i.right;
                    Dimension pref = myLabelContainer.getPreferredSize();
                    int w = Math.min(pw, pref.width);
                    int h = pref.height;
                    int x = i.left + pw - w;
                    int y = i.top;
                    myLabelContainer.setBounds(x, y, w, h);
                }
            });
            this.myLabelPanel.setOpaque(false);
            this.myLabelPanel.add(this.myLabelContainer);
            final JPanel layoutPanel = new JPanel(new BorderLayout());
            layoutPanel.setOpaque(false);
            layoutPanel.add((Component)headersPanel, "North");
            layoutPanel.add((Component)this.myItemPanel, "Center");
            this.myWrapperPanel.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    return layoutPanel.getPreferredSize();
                }

                public void layoutContainer(Container parent) {
                    Dimension size = parent.getSize();
                    Insets i = parent.getInsets();
                    Dimension pref = layoutPanel.getPreferredSize();
                    layoutPanel.setBounds(i.left, i.top, size.width - i.left - i.right, pref.height);
                }
            });
            this.myWrapperPanel.add(layoutPanel);
            this.myItemPanel.setBorder(this.myBorder);
            this.myItemPanel.setLayout(new BorderLayout());
            JPanel north = new JPanel(new BorderLayout());
            north.setOpaque(false);
            north.add((Component)this.myDateLabel, "West");
            north.add((Component)this.myFilesCountLabel, "East");
            JPanel south = new JPanel(new BorderLayout());
            south.add((Component)this.myTitleLabel, "Center");
            south.setOpaque(false);
            this.myItemPanel.add((Component)north, "North");
            this.myItemPanel.add((Component)south, "South");
            this.myLabelLabel.setBorder((Border)new EmptyBorder(0, 5, 1, 5));
            this.myLabelPanel.setBorder(new MyBorder(new Insets(4, 20, 3, 1)));
            this.myWrapperPanel.setOpaque(false);
            this.myItemPanel.setOpaque(true);
            this.myWrapperPanel.setBackground(table.getBackground());
            this.myDateLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            this.myFilesCountLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            this.myLabelLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
            this.myTitleLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            if (value == null) {
                return this.myWrapperPanel;
            }
            RevisionItem r = (RevisionItem)value;
            LabelsAndColor labelsAndColor = this.getLabelsAndColor(r);
            Period p = ((MyModel)table.getModel()).getPeriod(r);
            if (p == null) {
                this.myPeriodLabel.setVisible(false);
            } else {
                this.myPeriodLabel.setVisible(true);
                this.myPeriodLabel.setCaption(p.getDisplayString());
            }
            this.myBorder.set(row2 == table.getModel().getRowCount() - 1);
            this.myDateLabel.setText(this.ensureString(DateFormatUtil.formatPrettyDateTime((long)r.revision.getTimestamp())));
            this.myFilesCountLabel.setText(this.ensureString(labelsAndColor.filesCount));
            this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(labelsAndColor.isNamed ? 1 : 0));
            this.myTitleLabel.setText(this.ensureString(labelsAndColor.title));
            JComponent orig = (JComponent)this.myTemplate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
            if (labelsAndColor.label == null) {
                this.myLabelPanel.setVisible(false);
            } else {
                this.myLabelPanel.setVisible(true);
                this.myLabelLabel.setBackground((Color)labelsAndColor.label.second);
                this.myLabelContainer.set((Color)labelsAndColor.label.second);
                this.myLabelLabel.setText(this.ensureString((String)labelsAndColor.label.first));
            }
            Color fg = orig.getForeground();
            Color bg = isSelected && !table.isFocusOwner() ? UIUtil.getListUnfocusedSelectionBackground() : orig.getBackground();
            this.myDateLabel.setForeground(isSelected ? fg : JBColor.GRAY);
            this.myFilesCountLabel.setForeground(this.myDateLabel.getForeground());
            this.myTitleLabel.setForeground(isSelected || labelsAndColor.isNamed ? fg : JBColor.DARK_GRAY);
            this.myItemPanel.setBackground(bg);
            this.myWrapperPanel.doLayout();
            int height = this.myWrapperPanel.getPreferredSize().height;
            if (table.getRowHeight(row2) != height && height > 0) {
                table.setRowHeight(row2, height);
            }
            return this.myWrapperPanel;
        }

        private String ensureString(String s) {
            return StringUtil.isEmpty((String)s) ? " " : s;
        }

        private LabelsAndColor getLabelsAndColor(RevisionItem item) {
            boolean named;
            Revision r = item.revision;
            Pair<List<String>, Integer> affected = r.getAffectedFileNames();
            String title = r.getChangeSetName();
            boolean bl = named = title != null;
            if (title == null) {
                title = StringUtil.join((Collection)((Collection)affected.first), (String)", ");
                if (((List)affected.first).size() < (Integer)affected.second) {
                    title = title + "...";
                }
            }
            String filesCount = StringUtil.pluralize((String)LocalHistoryBundle.message("revisions.table.filesCount", affected.second), (int)((Integer)affected.second));
            Pair label2 = null;
            if (!item.labels.isEmpty()) {
                Revision first = item.labels.getFirst();
                label2 = Pair.create((Object)first.getLabel(), (Object)(first.getLabelColor() == -1 ? USER_LABEL_COLOR : new Color(first.getLabelColor())));
            }
            return new LabelsAndColor(named, title, filesCount, label2);
        }

        private static class MyLabelContainer
        extends JPanel {
            private MyLabelContainer() {
                super(new BorderLayout());
            }

            public void set(Color c) {
                this.setBackground(c);
            }

            @Override
            public Dimension getMinimumSize() {
                return super.getMinimumSize();
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(this.getBackground());
                g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getHeight() - 2, this.getHeight() - 2);
                g2d.setColor(this.getBackground().darker());
                g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getHeight() - 2, this.getHeight() - 2);
                g2d.dispose();
            }
        }

        private static class MyBorder
        extends EmptyBorder {
            private boolean isLast;

            private MyBorder(Insets insets) {
                super(insets);
            }

            public void set(boolean isLast) {
                this.isLast = isLast;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(UIUtil.getBorderColor());
                g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f}, 1.0f));
                g2d.drawLine(x, y, x + width, y);
                if (this.isLast) {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
                g2d.dispose();
            }
        }

        private static class LabelsAndColor {
            final boolean isNamed;
            final String title;
            final String filesCount;
            final Pair<String, Color> label;

            private LabelsAndColor(boolean isNamed, String title, String filesCount, Pair<String, Color> label2) {
                this.isNamed = isNamed;
                this.title = title;
                this.filesCount = filesCount;
                this.label = label2;
            }
        }

        private class MyWrapperPanel
        extends JPanel {
            private MyWrapperPanel() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleMyWrapperPanel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleMyWrapperPanel
            extends JPanel.AccessibleJPanel {
                protected AccessibleMyWrapperPanel() {
                    super(MyWrapperPanel.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.LABEL;
                }

                @Override
                public String getAccessibleName() {
                    if (MyCellRenderer.this.myPeriodLabel.isVisible()) {
                        return AccessibleContextUtil.getCombinedName((String)", ", (Component[])new Component[]{MyCellRenderer.this.myPeriodLabel, MyCellRenderer.this.myTitleLabel, MyCellRenderer.this.myFilesCountLabel, MyCellRenderer.this.myDateLabel});
                    }
                    return AccessibleContextUtil.getCombinedName((String)", ", (Component[])new Component[]{MyCellRenderer.this.myTitleLabel, MyCellRenderer.this.myFilesCountLabel, MyCellRenderer.this.myDateLabel});
                }
            }
        }
    }

    public static class MyModel
    extends AbstractTableModel {
        private final List<? extends RevisionItem> myRevisions;
        private final Map<RevisionItem, Period> myPeriods;

        public MyModel(List<? extends RevisionItem> revisions, Map<RevisionItem, Period> periods) {
            this.myRevisions = revisions;
            this.myPeriods = periods;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.myRevisions.size();
        }

        @Override
        public RevisionItem getValueAt(int rowIndex, int columnIndex) {
            return this.myRevisions.get(rowIndex);
        }

        public Period getPeriod(RevisionItem r) {
            return this.myPeriods.get(r);
        }
    }

    private static enum Period {
        RECENT(LocalHistoryBundle.message("revisions.table.period.recent", 12)),
        OLDER(LocalHistoryBundle.message("revisions.table.period.older", new Object[0])),
        OLD(LocalHistoryBundle.message("revisions.table.period.old", new Object[0]));

        private final String myDisplayString;

        private Period(String displayString) {
            this.myDisplayString = displayString;
        }

        public String getDisplayString() {
            return this.myDisplayString;
        }
    }

    public static interface SelectionListener {
        public void revisionsSelected(int var1, int var2);
    }
}

