/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class Locations {
    private static final File ourDataDir;

    Locations() {
    }

    public static File getDataRoot() {
        return ourDataDir;
    }

    @NotNull
    private static String normalizePathName(String path) {
        String string = path == null ? "unknown_vendor" : path.trim().replace(' ', '_');
        if (string == null) {
            Locations.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String relativeResourcePath = appInfo.isVendorJetBrains() ? "JetBrains" : Locations.normalizePathName(appInfo.getShortCompanyName());
        File dataDir = null;
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null) {
                dataDir = new File(appdata, relativeResourcePath);
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                if (SystemInfo.isMac) {
                    File dataRoot = new File(userHome, "/Library/Application Support");
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, relativeResourcePath);
                    }
                } else if (SystemInfo.isUnix) {
                    File dataRoot;
                    String dataHome = System.getenv("XDG_DATA_HOME");
                    File file2 = dataRoot = dataHome == null ? new File(userHome, ".local/share") : new File(dataHome);
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, relativeResourcePath);
                    }
                }
            }
        }
        if (dataDir == null) {
            dataDir = new File(PathManager.getSystemPath());
        }
        dataDir.mkdirs();
        ourDataDir = dataDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/Locations", "normalizePathName"));
    }
}

