/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPopup;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(AbstractValueHint.class);
    private final KeyListener myEditorKeyListener;
    private RangeHighlighter myHighlighter;
    private Cursor myStoredCursor;
    private final Project myProject;
    private final Editor myEditor;
    private final ValueHintType myType;
    protected final Point myPoint;
    protected LightweightHint myCurrentHint;
    private boolean myHintHidden;
    private TextRange myCurrentRange;
    private Runnable myHideRunnable;
    private static final Key<TextAttributes> HINT_TEXT_ATTRIBUTES = Key.create((String)"HINT_TEXT_ATTRIBUTES");
    private boolean myInsideShow;

    public AbstractValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange) {
        if (project == null) {
            AbstractValueHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(1);
        }
        if (point == null) {
            AbstractValueHint.$$$reportNull$$$0(2);
        }
        if (type == null) {
            AbstractValueHint.$$$reportNull$$$0(3);
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!AbstractValueHint.isAltMask(e.getModifiers())) {
                    ValueLookupManager.getInstance(AbstractValueHint.this.myProject).hideHint();
                }
            }
        };
        this.myInsideShow = false;
        this.myPoint = point;
        this.myProject = project;
        this.myEditor = editor;
        this.myType = type;
        this.myCurrentRange = textRange;
    }

    protected abstract boolean canShowHint();

    protected abstract void evaluateAndShowHint();

    public boolean isKeepHint(Editor editor, Point point) {
        return this.myType != ValueHintType.MOUSE_ALT_OVER_HINT;
    }

    boolean isInsideCurrentRange(Editor editor, Point point) {
        return this.myCurrentRange != null && this.myCurrentRange.contains(AbstractValueHint.calculateOffset(editor, point));
    }

    public static int calculateOffset(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(4);
        }
        if (point == null) {
            AbstractValueHint.$$$reportNull$$$0(5);
        }
        return editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
    }

    public void hideHint() {
        this.myHintHidden = true;
        this.myCurrentRange = null;
        if (this.myStoredCursor != null) {
            JComponent internalComponent = this.myEditor.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(myStoredCursor)");
            }
            internalComponent.removeKeyListener(this.myEditorKeyListener);
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
            this.myCurrentHint = null;
        }
        this.disposeHighlighter();
    }

    void disposeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    public void invokeHint() {
        this.invokeHint(null);
    }

    public void invokeHint(Runnable hideRunnable) {
        this.myHideRunnable = hideRunnable;
        if (!this.canShowHint() || !DocumentUtil.isValidOffset(this.myCurrentRange.getEndOffset(), this.myEditor.getDocument())) {
            this.hideHint();
            return;
        }
        this.createHighlighter();
        if (this.myType != ValueHintType.MOUSE_ALT_OVER_HINT) {
            this.evaluateAndShowHint();
        }
    }

    private void setHighlighterAttributes() {
        TextAttributes attributes;
        if (this.myHighlighter != null && (attributes = (TextAttributes)this.myHighlighter.getUserData(HINT_TEXT_ATTRIBUTES)) != null) {
            ((RangeHighlighterEx)this.myHighlighter).setTextAttributes(attributes);
        }
    }

    private void createHighlighter() {
        TextAttributes attributes;
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            attributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
            attributes = NavigationUtil.patchAttributesColor(attributes, this.myCurrentRange, this.myEditor);
        } else {
            attributes = new TextAttributes();
        }
        this.disposeHighlighter();
        this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), 6000, attributes, HighlighterTargetArea.EXACT_RANGE);
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            JComponent internalComponent = this.myEditor.getContentComponent();
            this.myStoredCursor = internalComponent.getCursor();
            internalComponent.addKeyListener(this.myEditorKeyListener);
            internalComponent.setCursor(AbstractValueHint.hintCursor());
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(hintCursor())");
            }
        } else {
            TextAttributesKey attributesKey = DebuggerColors.EVALUATED_EXPRESSION_ATTRIBUTES;
            MarkupModel model = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.myProject, false);
            if (model != null && !((MarkupModelEx)model).processRangeHighlightersOverlappingWith(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)h -> (Boolean)ExecutionPointHighlighter.EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY.get((UserDataHolder)h, (Object)false) == false))) {
                attributesKey = DebuggerColors.EVALUATED_EXPRESSION_EXECUTION_LINE_ATTRIBUTES;
            }
            this.myHighlighter.putUserData(HINT_TEXT_ATTRIBUTES, (Object)this.myEditor.getColorsScheme().getAttributes(attributesKey));
        }
    }

    private static Cursor hintCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(6);
        }
        return editor;
    }

    protected ValueHintType getType() {
        return this.myType;
    }

    protected boolean showHint(JComponent component) {
        this.myInsideShow = true;
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
        }
        this.myCurrentHint = new LightweightHint(component){

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                Component comp;
                InputEvent inputEvent = event.getInputEvent();
                if (inputEvent instanceof MouseEvent && (comp = inputEvent.getComponent()) instanceof EditorComponentImpl) {
                    EditorImpl editor = ((EditorComponentImpl)comp).getEditor();
                    return !AbstractValueHint.this.isInsideCurrentRange(editor, ((MouseEvent)inputEvent).getPoint());
                }
                return true;
            }
        };
        this.myCurrentHint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(@NotNull EventObject event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (AbstractValueHint.this.myHideRunnable != null && !AbstractValueHint.this.myInsideShow) {
                    AbstractValueHint.this.myHideRunnable.run();
                }
                AbstractValueHint.this.onHintHidden();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$3", "hintHidden"));
            }
        });
        if (this.myEditor.isDisposed() || this.myEditor.getComponent().getRootPane() == null) {
            return false;
        }
        AppUIUtil.targetToDevice(this.myCurrentHint.getComponent(), this.myEditor.getComponent());
        Point p = HintManagerImpl.getHintPosition(this.myCurrentHint, this.myEditor, this.myEditor.xyToLogicalPosition(this.myPoint), (short)2);
        HintHint hint = HintManagerImpl.createHintHint(this.myEditor, p, this.myCurrentHint, (short)2, true);
        hint.setShowImmediately(true);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myCurrentHint, this.myEditor, p, 42, 0, false, hint);
        this.setHighlighterAttributes();
        this.myInsideShow = false;
        return true;
    }

    protected void onHintHidden() {
        this.disposeHighlighter();
    }

    protected boolean isHintHidden() {
        return this.myHintHidden;
    }

    protected JComponent createExpandableHintComponent(SimpleColoredText text, final Runnable expand) {
        JComponent component = HintUtil.createInformationLabel(text, IconUtil.getAddIcon());
        component.setCursor(AbstractValueHint.hintCursor());
        AbstractValueHint.addClickListenerToHierarchy(component, new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (AbstractValueHint.this.myCurrentHint != null) {
                    AbstractValueHint.this.myCurrentHint.hide();
                }
                expand.run();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$4", "onClick"));
            }
        });
        return component;
    }

    private static void addClickListenerToHierarchy(Component c, ClickListener l) {
        l.installOn(c);
        if (c instanceof Container) {
            Component[] children2;
            for (Component child2 : children2 = ((Container)c).getComponents()) {
                AbstractValueHint.addClickListenerToHierarchy(child2, l);
            }
        }
    }

    @Nullable
    protected TextRange getCurrentRange() {
        return this.myCurrentRange;
    }

    private static boolean isAltMask(@JdkConstants.InputEventMask int modifiers) {
        return KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)KeymapManager.getInstance().getActiveKeymap(), (int)modifiers, (String)"QuickEvaluateExpression");
    }

    @Nullable
    public static ValueHintType getHintType(EditorMouseEvent e) {
        int modifiers = e.getMouseEvent().getModifiers();
        if (modifiers == 0) {
            return ValueHintType.MOUSE_OVER_HINT;
        }
        if (AbstractValueHint.isAltMask(modifiers)) {
            return ValueHintType.MOUSE_ALT_OVER_HINT;
        }
        return null;
    }

    public boolean isInsideHint(Editor editor, Point point) {
        return this.myCurrentHint != null && this.myCurrentHint.isInsideHint(new RelativePoint((Component)editor.getContentComponent(), point));
    }

    protected <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D descriptor) {
        if (creator == null) {
            AbstractValueHint.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            AbstractValueHint.$$$reportNull$$$0(8);
        }
        if (this.myEditor.isDisposed() || !DocumentUtil.isValidOffset(this.myCurrentRange.getEndOffset(), this.myEditor.getDocument())) {
            this.hideHint();
            return;
        }
        this.createHighlighter();
        this.setHighlighterAttributes();
        Point point = this.myEditor.visualPositionToXY(this.myEditor.xyToVisualPosition(this.myPoint));
        point.translate(0, this.myEditor.getLineHeight());
        DebuggerTreeWithHistoryPopup.showTreePopup(creator, descriptor, this.myEditor, point, this.getProject(), () -> {
            this.disposeHighlighter();
            if (this.myHideRunnable != null) {
                this.myHideRunnable.run();
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractValueHint hint = (AbstractValueHint)o;
        if (!this.myProject.equals(hint.myProject)) {
            return false;
        }
        if (!this.myEditor.equals(hint.myEditor)) {
            return false;
        }
        if (this.myType != hint.myType) {
            return false;
        }
        return Objects.equals(this.myCurrentRange, hint.myCurrentRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myProject, this.myEditor, this.myType, this.myCurrentRange});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showTreePopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

