/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSSeeAlsoDocBuilderInfo {
    @NonNls
    public static final String SEE_ALSO_DOC_TOKEN = "<tr><td valign='top' class='section'><p>See also:</td><td valign='top'>";
    @NotNull
    private final List<String> myTexts;
    @NotNull
    private final PsiElement myElement;

    public JSSeeAlsoDocBuilderInfo(@NotNull PsiElement element) {
        if (element == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(0);
        }
        this.myTexts = ContainerUtil.newSmartList();
        this.myElement = element;
    }

    void addText(@NotNull String text) {
        if (text == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(1);
        }
        this.myTexts.add(text);
    }

    public void appendDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider2) {
        if (result2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(3);
        }
        if (this.myTexts.isEmpty()) {
            return;
        }
        result2.append(SEE_ALSO_DOC_TOKEN);
        boolean isFirst = true;
        for (String text : this.myTexts) {
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(", ");
            }
            this.appendSection(text, result2, provider2);
        }
        result2.append("</td>");
    }

    private void appendSection(@NotNull String remainingLineContent, @NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider2) {
        String linkPart;
        String displayText;
        if (remainingLineContent == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(5);
        }
        if (provider2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(6);
        }
        if ((remainingLineContent = remainingLineContent.trim()).startsWith("\"") && remainingLineContent.endsWith("\"")) {
            result2.append(StringUtil.unquoteString((String)remainingLineContent));
            return;
        }
        int i = remainingLineContent.indexOf(32);
        if (i == -1) {
            linkPart = displayText = remainingLineContent;
        } else {
            linkPart = remainingLineContent.substring(0, i);
            displayText = remainingLineContent.substring(i + 1);
        }
        this.appendLink(result2, remainingLineContent, provider2, linkPart, displayText);
    }

    private void appendLink(@NotNull StringBuilder result2, @NotNull String remainingLineContent, @NotNull JSDocumentationProvider provider2, @NotNull String linkPart, @NotNull String displayText) {
        if (result2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(7);
        }
        if (remainingLineContent == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(8);
        }
        if (provider2 == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(9);
        }
        if (linkPart == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(10);
        }
        if (displayText == null) {
            JSSeeAlsoDocBuilderInfo.$$$reportNull$$$0(11);
        }
        if (BrowserUtil.isAbsoluteURL((String)linkPart)) {
            result2.append("<a href=\"").append(linkPart).append("\">").append(displayText).append("</a>");
        } else if (JSSeeAlsoDocBuilderInfo.looksLikeWebURL(linkPart)) {
            result2.append("<a href=\"http://").append(linkPart).append("\">").append(displayText).append("</a>");
        } else {
            String link = provider2.tryGetSeeAlsoLink(linkPart, this.myElement);
            if (link != null) {
                DocumentationManager.createHyperlink((StringBuilder)result2, (String)link, (String)displayText, (boolean)true);
            } else {
                result2.append(remainingLineContent);
            }
        }
    }

    private static boolean looksLikeWebURL(String linkPart) {
        return linkPart.startsWith("www.") && linkPart.matches("[a-z0-9./]+");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingLineContent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPart";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSSeeAlsoDocBuilderInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDoc";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

