/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcessResultCallbackBase;
import com.intellij.docker.agent.ResponseItemAggregator;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;

public class PullImageResultCallbackImpl
extends OngoingProcessResultCallbackBase<PullResponseItem> {
    private static final String DOWNLOADING_STATUS = "Downloading";
    private static final String DOWNLOAD_COMPLETE_STATUS = "Download complete";
    private static final String EXTRACTING_STATUS = "Extracting";
    private static final String PULL_COMPLETE_STATUS = "Pull complete";
    private final ResponseItemAggregator myDownloads = new ResponseItemAggregator();
    private final ResponseItemAggregator myExtractions = new ResponseItemAggregator();

    public PullImageResultCallbackImpl(DockerAgentProgressCallback callback, CloudAgentLogger logger) {
        super(callback, logger);
    }

    public void onNext(PullResponseItem item) {
        if (item.isPullSuccessIndicated()) {
            this.setSuccessMessage(item.getStatus());
        }
        if (item.isErrorIndicated()) {
            this.setErrorMessage(item.getErrorDetail().getMessage());
        }
        String status = item.getStatus();
        String id = item.getId();
        if (id != null && status != null) {
            if (DOWNLOADING_STATUS.equals(status)) {
                this.myDownloads.updateProgress((ResponseItem)item);
            } else if (DOWNLOAD_COMPLETE_STATUS.equals(status)) {
                this.myDownloads.completeProgress(id);
            } else if (EXTRACTING_STATUS.equals(status)) {
                this.myExtractions.updateProgress((ResponseItem)item);
            } else if (PULL_COMPLETE_STATUS.equals(status)) {
                this.myDownloads.completeProgress(id);
                this.myExtractions.completeProgress(id);
            }
        }
        this.updateIndicator(item);
    }

    @Override
    protected void ongoingProcessDelegateCancelled() {
        this.setSuccessMessage("Pull cancelled");
    }

    private void updateIndicator(PullResponseItem item) {
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null) {
            ResponseItemAggregator.ProgressInfo downloadProgress = this.myDownloads.computeAggregatedProgress();
            ResponseItemAggregator.ProgressInfo extractProgress = this.myExtractions.computeAggregatedProgress();
            if (!(downloadProgress == null || downloadProgress.isCompleted() && extractProgress != null)) {
                this.getAgentCallback().step(item.getStatus(), downloadProgress.getCurrent(), downloadProgress.getTotal());
            } else if (extractProgress != null && !extractProgress.isCompleted()) {
                this.getAgentCallback().step(item.getStatus(), extractProgress.getCurrent(), extractProgress.getTotal());
            }
        }
    }
}

