/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.controllers;

import b.h.la;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.jruby.warbler.helpers.WarblerConfigHelper;
import org.jetbrains.plugins.ruby.jruby.warbler.helpers.WarblerValidatorHelper;
import org.jetbrains.plugins.ruby.jruby.warbler.model.WarblerActionModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblemEnum;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog.WarblerDialog;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog.WarblerDialogListener;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;

public class WarblerDialogController {
    private static final Logger a;
    private final WarblerActionModel b;
    private final WarblerDialog c;
    private static final long d;

    public WarblerDialogController(final @NotNull WarblerActionModel model, @NotNull WarblerDialog view) {
        if (model == null) {
            WarblerDialogController.a(0);
        }
        if (view == null) {
            WarblerDialogController.a(1);
        }
        this.b = model;
        this.c = view;
        model.getConfig().addWarblerConfigChangedListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                model.setConfigProblem(WarblerValidatorHelper.checkConfig(model.getConfig()));
            }
        });
        model.setEnvironmentProblem(WarblerValidatorHelper.checkEnvironment(model.getModule()));
        view.addWarblerDialogListener(new WarblerDialogListener(){
            private static final long a = la.a(-4347838221273217448L, -2554412367249720875L, MethodHandles.lookup().lookupClass()).a(233867728370615L);

            @Override
            public void fixActionPerformed(@NotNull WarblerEnvironmentProblemEnum warblerEnvironmentProblemEnum) {
                if (warblerEnvironmentProblemEnum == null) {
                    2.a(0);
                }
                WarblerDialogController.this.fixProblem(warblerEnvironmentProblemEnum);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xB24F49E2A5AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warblerEnvironmentProblemEnum", "org/jetbrains/plugins/ruby/jruby/warbler/controllers/WarblerDialogController$2", "fixActionPerformed"));
            }
        });
    }

    public void run() {
        long l2 = d ^ 0x352D9A619854L;
        if (this.c.showAndGet()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)this.b.getModule()).getSdk();
            assert (sdk != null);
            try {
                WarblerConfigHelper.saveConfig(this.b.getModule(), this.b.getConfig());
                String[] stringArray = this.b.getConfig().isTrace() ? new String[]{"-t"} : ArrayUtil.EMPTY_STRING_ARRAY;
                MergingCommandLineArgumentsProvider mergingCommandLineArgumentsProvider = new MergingCommandLineArgumentsProvider(stringArray, null, null, null, sdk);
                Filter[] filterArray = new Filter[]{new RStackTraceFilter(this.b.getModule())};
                FileDocumentManager.getInstance().saveAllDocuments();
                GemsRunner.runGemScriptInConsoleAndRefreshModule(this.b.getModule(), sdk, RBundle.message((String)"warbler.dialog.caption"), null, ConsoleRunner.ProcessLaunchMode.BACKGROUND_TASK_WITH_PROGRESS, "warbler", null, "warble", WarblerConfigHelper.getModuleDir(this.b.getModule()).getPath(), mergingCommandLineArgumentsProvider, new RunContentDescriptorFactory.PinTabsFactory(), filterArray, null, true);
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                String string = RBundle.message((String)"warbler.config.patching.error", (Object[])new Object[]{iOException.getMessage()});
                Messages.showErrorDialog((Project)this.b.getModule().getProject(), (String)string, (String)RBundle.message((String)"warbler.dialog.error.title"));
            }
        }
    }

    protected void installGem(@NotNull String gemName) {
        if (gemName == null) {
            WarblerDialogController.a(2);
        }
        Module module = this.b.getModule();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        RailsUtil.installGemSupport(sdk, module, null, gemName, null);
    }

    protected void executeAction(@NotNull String actionId) {
        long l2 = d ^ 0x5A69B3F40698L;
        if (actionId == null) {
            WarblerDialogController.a(3);
        }
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"unknown", (DataContext)this.b.getDataContext());
        anAction.beforeActionPerformedUpdate(anActionEvent);
        anAction.update(anActionEvent);
        if (anActionEvent.getPresentation().isEnabled() && anActionEvent.getPresentation().isVisible()) {
            anAction.actionPerformed(anActionEvent);
        }
    }

    protected void fixProblem(WarblerEnvironmentProblemEnum warblerEnvironmentProblemEnum) {
        long l2 = d ^ 0x118EBF3CE52CL;
        if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.WRONG_SDK) {
            this.executeAction("GemRequirements.ShowSettings");
        } else if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.RAILS_NOT_FOUND) {
            this.installGem("rails");
        } else if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.WARBLER_NOT_FOUND) {
            this.installGem("warbler");
        }
        this.b.setEnvironmentProblem(WarblerValidatorHelper.checkEnvironment(this.b.getModule()));
    }

    static {
        d = la.a(1081593282803044461L, -4477350163518161773L, MethodHandles.lookup().lookupClass()).a(245866316066258L);
        a = Logger.getInstance(WarblerDialogController.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x56EBDA9FF4A3L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/controllers/WarblerDialogController";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installGem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

