/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.AnchorableComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCheckBox
extends JCheckBox
implements AnchorableComponent {
    private JComponent myAnchor;

    public JBCheckBox() {
        this((String)null);
    }

    public JBCheckBox(@Nullable String text) {
        this(text, false);
    }

    public JBCheckBox(@Nullable String text, boolean selected) {
        super(text, null, selected);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myAnchor != null && this.myAnchor != this) {
            Dimension anchorSize = this.myAnchor.getPreferredSize();
            size.width = Math.max(size.width, anchorSize.width);
            size.height = Math.max(size.height, anchorSize.height);
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (this.myAnchor != null && this.myAnchor != this) {
            Dimension anchorSize = this.myAnchor.getMinimumSize();
            size.width = Math.max(size.width, anchorSize.width);
            size.height = Math.max(size.height, anchorSize.height);
        }
        return size;
    }

    public boolean setTextIcon(@NotNull Icon icon) {
        Icon defaultIcon;
        if (icon == null) {
            JBCheckBox.$$$reportNull$$$0(0);
        }
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return false;
        }
        ButtonUI ui = this.getUI();
        if (ui instanceof BasicRadioButtonUI && (defaultIcon = ((BasicRadioButtonUI)ui).getDefaultIcon()) != null) {
            MergedIcon mergedIcon = new MergedIcon(defaultIcon, 10, icon);
            this.setIcon(mergedIcon);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/components/JBCheckBox", "setTextIcon"));
    }

    private static class MergedIcon
    implements Icon {
        private final Icon myLeftIcon;
        private final int myHorizontalStrut;
        private final Icon myRightIcon;

        MergedIcon(@NotNull Icon leftIcon, int horizontalStrut, @NotNull Icon rightIcon) {
            if (leftIcon == null) {
                MergedIcon.$$$reportNull$$$0(0);
            }
            if (rightIcon == null) {
                MergedIcon.$$$reportNull$$$0(1);
            }
            this.myLeftIcon = leftIcon;
            this.myHorizontalStrut = horizontalStrut;
            this.myRightIcon = rightIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIconAlignedCenter(c, g, x, y, this.myLeftIcon);
            this.paintIconAlignedCenter(c, g, x + this.myLeftIcon.getIconWidth() + this.myHorizontalStrut, y, this.myRightIcon);
        }

        private void paintIconAlignedCenter(Component c, Graphics g, int x, int y, @NotNull Icon icon) {
            if (icon == null) {
                MergedIcon.$$$reportNull$$$0(2);
            }
            int iconHeight = this.getIconHeight();
            icon.paintIcon(c, g, x, y + (iconHeight - icon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myLeftIcon.getIconWidth() + this.myHorizontalStrut + this.myRightIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.myLeftIcon.getIconHeight(), this.myRightIcon.getIconHeight());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftIcon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/components/JBCheckBox$MergedIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIconAlignedCenter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

