/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hsql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.hsql.HsqlTokens;
import com.intellij.sql.dialects.hsql.HsqlTypes;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqlDialect
extends SqlLanguageDialectEx {
    public static final HsqlDialect INSTANCE = new HsqlDialect();

    public HsqlDialect() {
        super("HSQLDB");
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HSQL;
        if (dbms == null) {
            HsqlDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            HsqlDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            HsqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            HsqlDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            HsqlDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName publicName = ObjectName.plain((String)"public");
        DasNamespace namespace = HsqlDialect.getDefaultNamespace(dataSource, publicName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(publicName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                HsqlDialect.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createPositiveDatabase(publicName, TreePatternUtils.create(publicName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]))));
        if (treePattern == null) {
            HsqlDialect.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            HsqlDialect.$$$reportNull$$$0(7);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "array";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            HsqlDialect.$$$reportNull$$$0(8);
        }
        if ("DEC".equals(name = super.getNormalizedTypeName(name))) {
            if ("DECIMAL" == null) {
                HsqlDialect.$$$reportNull$$$0(9);
            }
            return "DECIMAL";
        }
        if ("INT".equals(name)) {
            if ("INTEGER" == null) {
                HsqlDialect.$$$reportNull$$$0(10);
            }
            return "INTEGER";
        }
        if ("OBJECT".equals(name)) {
            if ("OTHER" == null) {
                HsqlDialect.$$$reportNull$$$0(11);
            }
            return "OTHER";
        }
        if ("FLOAT".equals(name)) {
            if ("DOUBLE" == null) {
                HsqlDialect.$$$reportNull$$$0(12);
            }
            return "DOUBLE";
        }
        if ("REAL".equals(name)) {
            if ("DOUBLE" == null) {
                HsqlDialect.$$$reportNull$$$0(13);
            }
            return "DOUBLE";
        }
        if ("DOUBLE PRECISION".equals(name)) {
            if ("DOUBLE" == null) {
                HsqlDialect.$$$reportNull$$$0(14);
            }
            return "DOUBLE";
        }
        if ("CHAR".equals(name)) {
            if ("CHARACTER" == null) {
                HsqlDialect.$$$reportNull$$$0(15);
            }
            return "CHARACTER";
        }
        if ("CHARACTER VARYING".equals(name)) {
            if ("VARCHAR" == null) {
                HsqlDialect.$$$reportNull$$$0(16);
            }
            return "VARCHAR";
        }
        if ("CHAR VARYING".equals(name)) {
            if ("VARCHAR" == null) {
                HsqlDialect.$$$reportNull$$$0(17);
            }
            return "VARCHAR";
        }
        if ("CHARACTER LARGE OBJECT".equals(name)) {
            if ("CLOB" == null) {
                HsqlDialect.$$$reportNull$$$0(18);
            }
            return "CLOB";
        }
        if ("CHAR LARGE OBJECT".equals(name)) {
            if ("CLOB" == null) {
                HsqlDialect.$$$reportNull$$$0(19);
            }
            return "CLOB";
        }
        if ("VARCHAR_IGNORECASE".equals(name)) {
            if ("VARCHAR" == null) {
                HsqlDialect.$$$reportNull$$$0(20);
            }
            return "VARCHAR";
        }
        if ("LONGVARCHAR".equals(name)) {
            if ("VARCHAR" == null) {
                HsqlDialect.$$$reportNull$$$0(21);
            }
            return "VARCHAR";
        }
        if ("BINARY VARYING".equals(name)) {
            if ("VARBINARY" == null) {
                HsqlDialect.$$$reportNull$$$0(22);
            }
            return "VARBINARY";
        }
        if ("BINARY LARGE OBJECT".equals(name)) {
            if ("BLOB" == null) {
                HsqlDialect.$$$reportNull$$$0(23);
            }
            return "BLOB";
        }
        if ("LONGVARBINARY".equals(name)) {
            if ("VARBINARY" == null) {
                HsqlDialect.$$$reportNull$$$0(24);
            }
            return "VARBINARY";
        }
        if ("DATETIME".equals(name)) {
            if ("TIMESTAMP" == null) {
                HsqlDialect.$$$reportNull$$$0(25);
            }
            return "TIMESTAMP";
        }
        String string = name;
        if (string == null) {
            HsqlDialect.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            HsqlDialect.$$$reportNull$$$0(27);
        }
        if ("CLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                HsqlDialect.$$$reportNull$$$0(28);
            }
            return category;
        }
        if ("BLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                HsqlDialect.$$$reportNull$$$0(29);
            }
            return category;
        }
        if ("BIT VARYING".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                HsqlDialect.$$$reportNull$$$0(30);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            HsqlDialect.$$$reportNull$$$0(31);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/hsql/HsqlDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 7: 
            case 8: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/hsql/HsqlDialect";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(HsqlTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        private static final EnterHandlerDelegate ENTER_HANDLER;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_INTERVAL, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LOGICAL_OR, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_NOT2, SqlTokens.SQL_OP_ASSIGN, SqlTokens.SQL_AT, SqlTokens.SQL_SECOND, SqlTokens.SQL_MINUTE, SqlTokens.SQL_HOUR, SqlTokens.SQL_DAY, SqlTokens.SQL_MONTH, SqlTokens.SQL_YEAR, SqlTokens.SQL_LEFT_BRACKET});
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_DO, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_FOR, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_ATOMIC, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_REPEAT, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{HsqlTypes.HSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, HsqlTypes.HSQL_WHILE, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));
        }
    }
}

