/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.AnalyticsQuery;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class IGainTermsQParserPlugin
extends QParserPlugin {
    public static final String NAME = "igain";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new IGainTermsQParser(qstr, localParams, params, req);
    }

    private static class TermWithScore
    implements Comparable<TermWithScore> {
        public final String term;
        public final double score;

        public TermWithScore(String term, double score) {
            this.term = term;
            this.score = score;
        }

        public int hashCode() {
            return this.term.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TermWithScore other = (TermWithScore)obj;
            return other.term.equals(this.term);
        }

        @Override
        public int compareTo(TermWithScore o) {
            int cmp = Double.compare(this.score, o.score);
            if (cmp == 0) {
                return this.term.compareTo(o.term);
            }
            return cmp;
        }
    }

    private static class IGainTermsCollector
    extends DelegatingCollector {
        private String field;
        private String outcome;
        private IndexSearcher searcher;
        private ResponseBuilder rb;
        private int positiveLabel;
        private int numTerms;
        private int count;
        private NumericDocValues leafOutcomeValue;
        private SparseFixedBitSet positiveSet;
        private SparseFixedBitSet negativeSet;
        private int numPositiveDocs;

        public IGainTermsCollector(ResponseBuilder rb, IndexSearcher searcher, String field, String outcome, int positiveLabel, int numTerms) {
            this.rb = rb;
            this.searcher = searcher;
            this.field = field;
            this.outcome = outcome;
            this.positiveSet = new SparseFixedBitSet(searcher.getIndexReader().maxDoc());
            this.negativeSet = new SparseFixedBitSet(searcher.getIndexReader().maxDoc());
            this.numTerms = numTerms;
            this.positiveLabel = positiveLabel;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            LeafReader reader = context.reader();
            this.leafOutcomeValue = reader.getNumericDocValues(this.outcome);
        }

        @Override
        public void collect(int doc) throws IOException {
            super.collect(doc);
            ++this.count;
            int value = this.leafOutcomeValue.advanceExact(doc) ? (int)this.leafOutcomeValue.longValue() : 0;
            if (value == this.positiveLabel) {
                this.positiveSet.set(this.context.docBase + doc);
                ++this.numPositiveDocs;
            } else {
                this.negativeSet.set(this.context.docBase + doc);
            }
        }

        @Override
        public void finish() throws IOException {
            BytesRef term;
            NamedList analytics = new NamedList();
            NamedList topFreq = new NamedList();
            NamedList allFreq = new NamedList();
            this.rb.rsp.add("featuredTerms", analytics);
            this.rb.rsp.add("docFreq", topFreq);
            this.rb.rsp.add("numDocs", this.count);
            TreeSet<TermWithScore> topTerms = new TreeSet<TermWithScore>();
            double numDocs = this.count;
            double pc = (double)this.numPositiveDocs / numDocs;
            double entropyC = this.binaryEntropy(pc);
            Terms terms = ((SolrIndexSearcher)this.searcher).getSlowAtomicReader().terms(this.field);
            TermsEnum termsEnum = terms == null ? TermsEnum.EMPTY : terms.iterator();
            PostingsEnum postingsEnum = null;
            while ((term = termsEnum.next()) != null) {
                postingsEnum = termsEnum.postings(postingsEnum);
                int xc = 0;
                int nc = 0;
                while (postingsEnum.nextDoc() != Integer.MAX_VALUE) {
                    if (this.positiveSet.get(postingsEnum.docID())) {
                        ++xc;
                        continue;
                    }
                    if (!this.negativeSet.get(postingsEnum.docID())) continue;
                    ++nc;
                }
                int docFreq = xc + nc;
                double entropyContainsTerm = this.binaryEntropy((double)xc / (double)docFreq);
                double entropyNotContainsTerm = this.binaryEntropy((double)(this.numPositiveDocs - xc) / (numDocs - (double)docFreq + 1.0));
                double score = entropyC - ((double)docFreq / numDocs * entropyContainsTerm + (1.0 - (double)docFreq / numDocs) * entropyNotContainsTerm);
                topFreq.add(term.utf8ToString(), (Object)docFreq);
                if (topTerms.size() < this.numTerms) {
                    topTerms.add(new TermWithScore(term.utf8ToString(), score));
                    continue;
                }
                if (!(((TermWithScore)topTerms.first()).score < score)) continue;
                topTerms.pollFirst();
                topTerms.add(new TermWithScore(term.utf8ToString(), score));
            }
            for (TermWithScore topTerm : topTerms) {
                analytics.add(topTerm.term, (Object)topTerm.score);
                topFreq.add(topTerm.term, allFreq.get(topTerm.term));
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }

        private double binaryEntropy(double prob) {
            if (prob == 0.0 || prob == 1.0) {
                return 0.0;
            }
            return -1.0 * prob * Math.log(prob) + -1.0 * (1.0 - prob) * Math.log(1.0 - prob);
        }
    }

    private static class IGainTermsQuery
    extends AnalyticsQuery {
        private String field;
        private String outcome;
        private int numTerms;
        private int positiveLabel;

        public IGainTermsQuery(String field, String outcome, int positiveLabel, int numTerms) {
            this.field = field;
            this.outcome = outcome;
            this.numTerms = numTerms;
            this.positiveLabel = positiveLabel;
        }

        @Override
        public DelegatingCollector getAnalyticsCollector(ResponseBuilder rb, IndexSearcher searcher) {
            return new IGainTermsCollector(rb, searcher, this.field, this.outcome, this.positiveLabel, this.numTerms);
        }
    }

    private static class IGainTermsQParser
    extends QParser {
        public IGainTermsQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String field = this.getParam("field");
            String outcome = this.getParam("outcome");
            int numTerms = Integer.parseInt(this.getParam("numTerms"));
            int positiveLabel = Integer.parseInt(this.getParam("positiveLabel"));
            return new IGainTermsQuery(field, outcome, positiveLabel, numTerms);
        }
    }
}

