/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.MaxScoreCollector;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.collector.FilterCollector;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;

public class QueryCommand
implements Command<QueryCommandResult> {
    private final Sort sort;
    private final Query query;
    private final DocSet docSet;
    private final int docsToCollect;
    private final boolean needScores;
    private final String queryString;
    private final Query mainQuery;
    private TopDocsCollector topDocsCollector;
    private FilterCollector filterCollector;
    private MaxScoreCollector maxScoreCollector;
    private TopDocs topDocs;

    private QueryCommand(Sort sort, Query query, int docsToCollect, boolean needScores, DocSet docSet, String queryString, Query mainQuery) {
        this.sort = sort;
        this.query = query;
        this.docsToCollect = docsToCollect;
        this.needScores = needScores;
        this.docSet = docSet;
        this.queryString = queryString;
        this.mainQuery = mainQuery;
    }

    @Override
    public List<Collector> create() throws IOException {
        TopScoreDocCollector subCollector;
        if (this.sort == null || this.sort.equals((Object)Sort.RELEVANCE)) {
            this.topDocsCollector = TopScoreDocCollector.create((int)this.docsToCollect, (int)Integer.MAX_VALUE);
            subCollector = this.topDocsCollector;
        } else {
            this.topDocsCollector = TopFieldCollector.create((Sort)this.sort, (int)this.docsToCollect, (int)Integer.MAX_VALUE);
            if (this.needScores) {
                this.maxScoreCollector = new MaxScoreCollector();
                subCollector = MultiCollector.wrap((Collector[])new Collector[]{this.topDocsCollector, this.maxScoreCollector});
            } else {
                subCollector = this.topDocsCollector;
            }
        }
        this.filterCollector = new FilterCollector(this.docSet, (Collector)subCollector);
        return Arrays.asList(new Collector[]{this.filterCollector});
    }

    @Override
    public void postCollect(IndexSearcher searcher) throws IOException {
        this.topDocs = this.topDocsCollector.topDocs();
        if (this.needScores) {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)searcher, (Query)this.mainQuery);
        }
    }

    @Override
    public QueryCommandResult result() throws IOException {
        float maxScore = this.sort == null ? (this.topDocs.scoreDocs.length == 0 ? Float.NaN : this.topDocs.scoreDocs[0].score) : (this.maxScoreCollector == null ? Float.NaN : this.maxScoreCollector.getMaxScore());
        return new QueryCommandResult(this.topDocs, this.filterCollector.getMatches(), maxScore);
    }

    @Override
    public String getKey() {
        return this.queryString != null ? this.queryString : this.query.toString();
    }

    @Override
    public Sort getGroupSort() {
        return this.sort;
    }

    @Override
    public Sort getWithinGroupSort() {
        return null;
    }

    public static class Builder {
        private Sort sort;
        private String queryString;
        private Query query;
        private Query mainQuery;
        private DocSet docSet;
        private Integer docsToCollect;
        private boolean needScores;

        public Builder setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder setQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder setMainQuery(Query mainQuery) {
            this.mainQuery = mainQuery;
            return this;
        }

        public Builder setQuery(String groupQueryString, SolrQueryRequest request) throws SyntaxError {
            QParser parser = QParser.getParser(groupQueryString, request);
            this.queryString = groupQueryString;
            return this.setQuery(parser.getQuery());
        }

        public Builder setDocSet(DocSet docSet) {
            this.docSet = docSet;
            return this;
        }

        public Builder setDocSet(SolrIndexSearcher searcher) throws IOException {
            return this.setDocSet(searcher.getDocSet(this.query));
        }

        public Builder setDocsToCollect(int docsToCollect) {
            this.docsToCollect = docsToCollect;
            return this;
        }

        public Builder setNeedScores(boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public QueryCommand build() {
            if (this.sort == null || this.query == null || this.docSet == null || this.docsToCollect == null || this.mainQuery == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new QueryCommand(this.sort, this.query, this.docsToCollect, this.needScores, this.docSet, this.queryString, this.mainQuery);
        }
    }
}

