/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTIssuerConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PARAM_ISS_NAME = "name";
    @Deprecated
    static final String PARAM_JWK_URL = "jwkUrl";
    static final String PARAM_JWKS_URL = "jwksUrl";
    static final String PARAM_JWK = "jwk";
    static final String PARAM_ISSUER = "iss";
    static final String PARAM_AUDIENCE = "aud";
    static final String PARAM_WELL_KNOWN_URL = "wellKnownUrl";
    static final String PARAM_AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    static final String PARAM_CLIENT_ID = "clientId";
    private static HttpsJwksFactory httpsJwksFactory = new HttpsJwksFactory(3600L, 5000L);
    private String iss;
    private String aud;
    private JsonWebKeySet jsonWebKeySet;
    private String name;
    private List<String> jwksUrl;
    private List<HttpsJwks> httpsJwks;
    private String wellKnownUrl;
    private WellKnownDiscoveryConfig wellKnownDiscoveryConfig;
    private String clientId;
    private String authorizationEndpoint;
    public static boolean ALLOW_OUTBOUND_HTTP = Boolean.parseBoolean(System.getProperty("solr.auth.jwt.allowOutboundHttp", "false"));
    public static final String ALLOW_OUTBOUND_HTTP_ERR_MSG = "HTTPS required for IDP communication. Please use SSL or start your nodes with -Dsolr.auth.jwt.allowOutboundHttp=true to allow HTTP for test purposes.";

    public JWTIssuerConfig(String name) {
        this.name = name;
    }

    public JWTIssuerConfig(Map<String, Object> configMap) {
        this.parseConfigMap(configMap);
    }

    public void init() {
        if (!this.isValid()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration is not valid");
        }
        if (this.wellKnownUrl != null) {
            this.wellKnownDiscoveryConfig = this.fetchWellKnown(this.wellKnownUrl);
            if (this.iss == null) {
                this.iss = this.wellKnownDiscoveryConfig.getIssuer();
            }
            if (this.jwksUrl == null) {
                this.jwksUrl = Collections.singletonList(this.wellKnownDiscoveryConfig.getJwksUrl());
            }
            if (this.authorizationEndpoint == null) {
                this.authorizationEndpoint = this.wellKnownDiscoveryConfig.getAuthorizationEndpoint();
            }
        }
        if (this.iss == null && this.usesHttpsJwk() && !"PRIMARY".equals(this.name)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required config 'iss' for issuer " + this.getName());
        }
    }

    protected void parseConfigMap(Map<String, Object> configMap) {
        HashMap<String, Object> conf = new HashMap<String, Object>(configMap);
        this.setName((String)conf.get(PARAM_ISS_NAME));
        this.setWellKnownUrl((String)conf.get(PARAM_WELL_KNOWN_URL));
        this.setIss((String)conf.get(PARAM_ISSUER));
        this.setClientId((String)conf.get(PARAM_CLIENT_ID));
        this.setAud((String)conf.get(PARAM_AUDIENCE));
        if (conf.get(PARAM_JWK_URL) != null) {
            log.warn("Configuration uses deprecated key {}. Please use {} instead", (Object)PARAM_JWK_URL, (Object)PARAM_JWKS_URL);
        }
        Object confJwksUrl = conf.get(PARAM_JWKS_URL) != null ? conf.get(PARAM_JWKS_URL) : conf.get(PARAM_JWK_URL);
        this.setJwksUrl(confJwksUrl);
        this.setJsonWebKeySet(conf.get(PARAM_JWK));
        this.setAuthorizationEndpoint((String)conf.get(PARAM_AUTHORIZATION_ENDPOINT));
        conf.remove(PARAM_WELL_KNOWN_URL);
        conf.remove(PARAM_ISSUER);
        conf.remove(PARAM_ISS_NAME);
        conf.remove(PARAM_CLIENT_ID);
        conf.remove(PARAM_AUDIENCE);
        conf.remove(PARAM_JWKS_URL);
        conf.remove(PARAM_JWK_URL);
        conf.remove(PARAM_JWK);
        conf.remove(PARAM_AUTHORIZATION_ENDPOINT);
        if (!conf.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration key " + conf.keySet() + " for issuer " + this.name);
        }
    }

    protected void setJsonWebKeySet(Object jwksObject) {
        try {
            if (jwksObject != null) {
                this.jsonWebKeySet = JWTIssuerConfig.parseJwkSet((Map)jwksObject);
            }
        }
        catch (JoseException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed parsing parameter 'jwk' for issuer " + this.getName(), (Throwable)e);
        }
    }

    protected static JsonWebKeySet parseJwkSet(Map<String, Object> jwkObj) throws JoseException {
        JsonWebKeySet webKeySet = new JsonWebKeySet(new JsonWebKey[0]);
        if (jwkObj.containsKey("keys")) {
            List jwkList = (List)jwkObj.get("keys");
            for (Object jwkO : jwkList) {
                webKeySet.addJsonWebKey(JsonWebKey.Factory.newJwk((Map)((Map)jwkO)));
            }
        } else {
            webKeySet = new JsonWebKeySet(new JsonWebKey[]{JsonWebKey.Factory.newJwk(jwkObj)});
        }
        return webKeySet;
    }

    private WellKnownDiscoveryConfig fetchWellKnown(String wellKnownUrl) {
        return WellKnownDiscoveryConfig.parse(wellKnownUrl);
    }

    public String getIss() {
        return this.iss;
    }

    public JWTIssuerConfig setIss(String iss) {
        this.iss = iss;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JWTIssuerConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getWellKnownUrl() {
        return this.wellKnownUrl;
    }

    public JWTIssuerConfig setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
        return this;
    }

    public List<String> getJwksUrls() {
        return this.jwksUrl;
    }

    public JWTIssuerConfig setJwksUrl(List<String> jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    public JWTIssuerConfig setJwksUrl(Object jwksUrlListOrString) {
        if (jwksUrlListOrString instanceof String) {
            this.jwksUrl = Collections.singletonList((String)jwksUrlListOrString);
        } else if (jwksUrlListOrString instanceof List) {
            this.jwksUrl = (List)jwksUrlListOrString;
        } else if (jwksUrlListOrString != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parameter jwksUrl must be either List or String");
        }
        return this;
    }

    public List<HttpsJwks> getHttpsJwks() {
        if (this.httpsJwks == null) {
            this.httpsJwks = httpsJwksFactory.createList(this.getJwksUrls());
        }
        return this.httpsJwks;
    }

    public static void setHttpsJwksFactory(HttpsJwksFactory httpsJwksFactory) {
        JWTIssuerConfig.httpsJwksFactory = httpsJwksFactory;
    }

    public JsonWebKeySet getJsonWebKeySet() {
        return this.jsonWebKeySet;
    }

    public JWTIssuerConfig setJsonWebKeySet(JsonWebKeySet jsonWebKeySet) {
        this.jsonWebKeySet = jsonWebKeySet;
        return this;
    }

    public boolean usesHttpsJwk() {
        return this.getJwksUrls() != null && !this.getJwksUrls().isEmpty();
    }

    public WellKnownDiscoveryConfig getWellKnownDiscoveryConfig() {
        return this.wellKnownDiscoveryConfig;
    }

    public String getAud() {
        return this.aud;
    }

    public JWTIssuerConfig setAud(String aud) {
        this.aud = aud;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public JWTIssuerConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public JWTIssuerConfig setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public Map<String, Object> asConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        this.putIfNotNull(config, PARAM_ISS_NAME, this.name);
        this.putIfNotNull(config, PARAM_ISSUER, this.iss);
        this.putIfNotNull(config, PARAM_AUDIENCE, this.aud);
        this.putIfNotNull(config, PARAM_JWKS_URL, this.jwksUrl);
        this.putIfNotNull(config, PARAM_WELL_KNOWN_URL, this.wellKnownUrl);
        this.putIfNotNull(config, PARAM_CLIENT_ID, this.clientId);
        this.putIfNotNull(config, PARAM_AUTHORIZATION_ENDPOINT, this.authorizationEndpoint);
        if (this.jsonWebKeySet != null) {
            this.putIfNotNull(config, PARAM_JWK, this.jsonWebKeySet.getJsonWebKeys());
        }
        return config;
    }

    private void putIfNotNull(HashMap<String, Object> config, String paramName, Object value) {
        if (value != null) {
            config.put(paramName, value);
        }
    }

    public boolean isValid() {
        int jwkConfigured = this.wellKnownUrl != null ? 1 : 0;
        jwkConfigured += this.jwksUrl != null ? 2 : 0;
        if ((jwkConfigured += this.jsonWebKeySet != null ? 2 : 0) > 3) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuthPlugin needs to configure exactly one of wellKnownUrl, jwksUrl and jwk");
        }
        if (jwkConfigured > 0 && this.name == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parameter 'name' is required for issuer configurations");
        }
        return jwkConfigured > 0;
    }

    public static void checkAllowOutboundHttpConnections(String parameterName, URL url) {
        if ("http".equalsIgnoreCase(url.getProtocol()) && !ALLOW_OUTBOUND_HTTP) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, parameterName + " is using http protocol. " + ALLOW_OUTBOUND_HTTP_ERR_MSG);
        }
    }

    public static class WellKnownDiscoveryConfig {
        private Map<String, Object> securityConf;

        WellKnownDiscoveryConfig(Map<String, Object> securityConf) {
            this.securityConf = securityConf;
        }

        public static WellKnownDiscoveryConfig parse(String urlString) {
            try {
                URL url = new URL(urlString);
                if (!Arrays.asList("https", "file", "http").contains(url.getProtocol())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Well-known config URL must be one of HTTPS or HTTP or file");
                }
                JWTIssuerConfig.checkAllowOutboundHttpConnections(JWTIssuerConfig.PARAM_WELL_KNOWN_URL, url);
                return WellKnownDiscoveryConfig.parse(url.openStream());
            }
            catch (MalformedURLException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Well-known config URL " + urlString + " is malformed", (Throwable)e);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Well-known config could not be read from url " + urlString, (Throwable)e);
            }
        }

        public static WellKnownDiscoveryConfig parse(String json, Charset charset) {
            return WellKnownDiscoveryConfig.parse(new ByteArrayInputStream(json.getBytes(charset)));
        }

        public static WellKnownDiscoveryConfig parse(InputStream configStream) {
            return new WellKnownDiscoveryConfig((Map)Utils.fromJSON((InputStream)configStream));
        }

        public String getJwksUrl() {
            return (String)this.securityConf.get("jwks_uri");
        }

        public String getIssuer() {
            return (String)this.securityConf.get("issuer");
        }

        public String getAuthorizationEndpoint() {
            return (String)this.securityConf.get("authorization_endpoint");
        }

        public String getUserInfoEndpoint() {
            return (String)this.securityConf.get("userinfo_endpoint");
        }

        public String getTokenEndpoint() {
            return (String)this.securityConf.get("token_endpoint");
        }

        public List<String> getScopesSupported() {
            return (List)this.securityConf.get("scopes_supported");
        }

        public List<String> getResponseTypesSupported() {
            return (List)this.securityConf.get("response_types_supported");
        }
    }

    static class HttpsJwksFactory {
        private final long jwkCacheDuration;
        private final long refreshReprieveThreshold;

        public HttpsJwksFactory(long jwkCacheDuration, long refreshReprieveThreshold) {
            this.jwkCacheDuration = jwkCacheDuration;
            this.refreshReprieveThreshold = refreshReprieveThreshold;
        }

        private HttpsJwks create(String url) {
            try {
                URL jwksUrl = new URL(url);
                JWTIssuerConfig.checkAllowOutboundHttpConnections(JWTIssuerConfig.PARAM_JWKS_URL, jwksUrl);
            }
            catch (MalformedURLException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Url " + url + " configured in " + JWTIssuerConfig.PARAM_JWKS_URL + " is not a valid URL");
            }
            HttpsJwks httpsJkws = new HttpsJwks(url);
            httpsJkws.setDefaultCacheDuration(this.jwkCacheDuration);
            httpsJkws.setRefreshReprieveThreshold(this.refreshReprieveThreshold);
            return httpsJkws;
        }

        public List<HttpsJwks> createList(List<String> jwkUrls) {
            return jwkUrls.stream().map(this::create).collect(Collectors.toList());
        }
    }
}

