/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.util.SuppressForbidden;

public class BlockCacheLocation {
    private int block;
    private int bankId;
    private long lastAccess;
    private long accesses = -1L;
    private AtomicBoolean removed = new AtomicBoolean(false);

    public BlockCacheLocation() {
        this.touch();
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setBankId(int bankId) {
        this.bankId = bankId;
    }

    public int getBlock() {
        return this.block;
    }

    public int getBankId() {
        return this.bankId;
    }

    @SuppressForbidden(reason="Need currentTimeMillis, only used by unused getLastAccess")
    public void touch() {
        this.lastAccess = System.currentTimeMillis();
        ++this.accesses;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getNumberOfAccesses() {
        return this.accesses;
    }

    public boolean isRemoved() {
        return this.removed.get();
    }

    public void setRemoved(boolean removed) {
        this.removed.set(removed);
    }
}

