/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteLogger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public class VisitorDataContext
implements DataContext {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger((String)VisitorDataContext.class.getName()));
    private final @Nullable Object[] values;

    public VisitorDataContext(@Nullable Object[] values) {
        this.values = values;
    }

    @Override
    public SchemaPlus getRootSchema() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public QueryProvider getQueryProvider() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public @Nullable Object get(String name) {
        if (name.equals("inputRecord")) {
            return this.values;
        }
        return null;
    }

    public static @Nullable DataContext of(RelNode targetRel, LogicalFilter queryRel) {
        return VisitorDataContext.of(targetRel.getRowType(), queryRel.getCondition());
    }

    public static @Nullable DataContext of(RelDataType rowType, RexNode rex) {
        RexNode secondOperand;
        int size = rowType.getFieldList().size();
        List<RexNode> operands = ((RexCall)rex).getOperands();
        RexNode firstOperand = operands.get(0);
        Pair<Integer, ? extends Object> value = VisitorDataContext.getValue(firstOperand, secondOperand = operands.get(1));
        if (value != null) {
            @Nullable Object[] values = new Object[size];
            int index = value.getKey();
            values[index] = value.getValue();
            return new VisitorDataContext(values);
        }
        return null;
    }

    public static @Nullable DataContext of(RelDataType rowType, List<? extends Pair<RexInputRef, ? extends @Nullable RexNode>> usageList) {
        int size = rowType.getFieldList().size();
        @Nullable Object[] values = new Object[size];
        for (Pair<RexInputRef, ? extends RexNode> pair : usageList) {
            Pair<Integer, ? extends Object> value = VisitorDataContext.getValue(pair.getKey(), pair.getValue());
            if (value == null) {
                LOGGER.warn("{} is not handled for {} for checking implication", (Object)pair.getKey(), (Object)pair.getValue());
                return null;
            }
            int index = value.getKey();
            values[index] = value.getValue();
        }
        return new VisitorDataContext(values);
    }

    public static @Nullable Pair<Integer, ? extends @Nullable Object> getValue(@Nullable RexNode inputRef, @Nullable RexNode literal) {
        inputRef = inputRef == null ? null : RexUtil.removeCast(inputRef);
        RexNode rexNode = literal = literal == null ? null : RexUtil.removeCast(literal);
        if (inputRef instanceof RexInputRef && literal instanceof RexLiteral) {
            int index = ((RexInputRef)inputRef).getIndex();
            RexLiteral rexLiteral = (RexLiteral)literal;
            RelDataType type = inputRef.getType();
            if (type.getSqlTypeName() == null) {
                LOGGER.warn("{} returned null SqlTypeName", inputRef.toString());
                return null;
            }
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    return Pair.of(index, rexLiteral.getValueAs(Integer.class));
                }
                case DOUBLE: {
                    return Pair.of(index, rexLiteral.getValueAs(Double.class));
                }
                case REAL: {
                    return Pair.of(index, rexLiteral.getValueAs(Float.class));
                }
                case BIGINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Long.class));
                }
                case SMALLINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Short.class));
                }
                case TINYINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Byte.class));
                }
                case DECIMAL: {
                    return Pair.of(index, rexLiteral.getValueAs(BigDecimal.class));
                }
                case DATE: 
                case TIME: {
                    return Pair.of(index, rexLiteral.getValueAs(Integer.class));
                }
                case TIMESTAMP: {
                    return Pair.of(index, rexLiteral.getValueAs(Long.class));
                }
                case CHAR: {
                    return Pair.of(index, rexLiteral.getValueAs(Character.class));
                }
                case VARCHAR: {
                    return Pair.of(index, rexLiteral.getValueAs(String.class));
                }
            }
            Comparable value = rexLiteral.getValue();
            LOGGER.warn("{} for value of class {} is being handled in default way", (Object)type.getSqlTypeName(), (Object)(value == null ? null : value.getClass()));
            if (value instanceof NlsString) {
                return Pair.of(index, ((NlsString)value).getValue());
            }
            return Pair.of(index, value);
        }
        return null;
    }
}

