/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DelegationTokenAuthenticatedURL
extends AuthenticatedURL {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenAuthenticatedURL.class);
    static final String DO_AS = "doAs";
    private static Class<? extends DelegationTokenAuthenticator> DEFAULT_AUTHENTICATOR = KerberosDelegationTokenAuthenticator.class;
    private boolean useQueryStringforDelegationToken = false;

    public static void setDefaultDelegationTokenAuthenticator(Class<? extends DelegationTokenAuthenticator> authenticator) {
        DEFAULT_AUTHENTICATOR = authenticator;
    }

    public static Class<? extends DelegationTokenAuthenticator> getDefaultDelegationTokenAuthenticator() {
        return DEFAULT_AUTHENTICATOR;
    }

    private static DelegationTokenAuthenticator obtainDelegationTokenAuthenticator(DelegationTokenAuthenticator dta, ConnectionConfigurator connConfigurator) {
        try {
            if (dta == null) {
                dta = DEFAULT_AUTHENTICATOR.newInstance();
                dta.setConnectionConfigurator(connConfigurator);
            }
            return dta;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DelegationTokenAuthenticatedURL() {
        this(null, null);
    }

    public DelegationTokenAuthenticatedURL(DelegationTokenAuthenticator authenticator) {
        this(authenticator, null);
    }

    public DelegationTokenAuthenticatedURL(ConnectionConfigurator connConfigurator) {
        this(null, connConfigurator);
    }

    public DelegationTokenAuthenticatedURL(DelegationTokenAuthenticator authenticator, ConnectionConfigurator connConfigurator) {
        super((Authenticator)DelegationTokenAuthenticatedURL.obtainDelegationTokenAuthenticator(authenticator, connConfigurator), connConfigurator);
    }

    @Deprecated
    protected void setUseQueryStringForDelegationToken(boolean useQueryString) {
        this.useQueryStringforDelegationToken = useQueryString;
    }

    public boolean useQueryStringForDelegationToken() {
        return this.useQueryStringforDelegationToken;
    }

    public HttpURLConnection openConnection(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        return token instanceof Token ? this.openConnection(url, (Token)token) : super.openConnection(url, token);
    }

    public HttpURLConnection openConnection(URL url, Token token) throws IOException, AuthenticationException {
        return this.openConnection(url, token, null);
    }

    private URL augmentURL(URL url, Map<String, String> params) throws IOException {
        if (params != null && params.size() > 0) {
            String urlStr = url.toExternalForm();
            StringBuilder sb = new StringBuilder(urlStr);
            String separator = urlStr.contains("?") ? "&" : "?";
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append(separator).append(param.getKey()).append("=").append(param.getValue());
                separator = "&";
            }
            url = new URL(sb.toString());
        }
        return url;
    }

    public HttpURLConnection openConnection(URL url, Token token, String doAs) throws IOException, AuthenticationException {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)((Object)token), (Object)"token");
        HashMap<String, String> extraParams = new HashMap<String, String>();
        org.apache.hadoop.security.token.Token<? extends TokenIdentifier> dToken = null;
        LOG.debug("Connecting to url {} with token {} as {}", new Object[]{url, token, doAs});
        if (!token.isSet()) {
            Credentials creds = UserGroupInformation.getCurrentUser().getCredentials();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Token not set, looking for delegation token. Creds:{}, size:{}", creds.getAllTokens(), (Object)creds.numberOfTokens());
            }
            if (!creds.getAllTokens().isEmpty() && (dToken = this.selectDelegationToken(url, creds)) != null) {
                if (this.useQueryStringForDelegationToken()) {
                    extraParams.put("delegation", dToken.encodeToUrlString());
                } else {
                    token.delegationToken = dToken;
                }
            }
        }
        if (doAs != null) {
            extraParams.put(DO_AS, URLEncoder.encode(doAs, "UTF-8"));
        }
        url = this.augmentURL(url, extraParams);
        HttpURLConnection conn = super.openConnection(url, (AuthenticatedURL.Token)token);
        if (!token.isSet() && !this.useQueryStringForDelegationToken() && dToken != null) {
            conn.setRequestProperty("X-Hadoop-Delegation-Token", dToken.encodeToUrlString());
        }
        return conn;
    }

    @InterfaceAudience.Private
    public org.apache.hadoop.security.token.Token<? extends TokenIdentifier> selectDelegationToken(URL url, Credentials creds) {
        InetSocketAddress serviceAddr = new InetSocketAddress(url.getHost(), url.getPort());
        Text service = SecurityUtil.buildTokenService(serviceAddr);
        org.apache.hadoop.security.token.Token<? extends TokenIdentifier> dToken = creds.getToken(service);
        LOG.debug("Using delegation token {} from service:{}", dToken, (Object)service);
        return dToken;
    }

    public org.apache.hadoop.security.token.Token<AbstractDelegationTokenIdentifier> getDelegationToken(URL url, Token token, String renewer) throws IOException, AuthenticationException {
        return this.getDelegationToken(url, token, renewer, null);
    }

    public org.apache.hadoop.security.token.Token<AbstractDelegationTokenIdentifier> getDelegationToken(URL url, Token token, String renewer, String doAsUser) throws IOException, AuthenticationException {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)((Object)token), (Object)"token");
        try {
            token.delegationToken = ((KerberosDelegationTokenAuthenticator)this.getAuthenticator()).getDelegationToken(url, token, renewer, doAsUser);
            return token.delegationToken;
        }
        catch (IOException ex) {
            token.delegationToken = null;
            throw ex;
        }
    }

    public long renewDelegationToken(URL url, Token token) throws IOException, AuthenticationException {
        return this.renewDelegationToken(url, token, null);
    }

    public long renewDelegationToken(URL url, Token token, String doAsUser) throws IOException, AuthenticationException {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)((Object)token), (Object)"token");
        Preconditions.checkNotNull((Object)token.delegationToken, (Object)"No delegation token available");
        try {
            return ((KerberosDelegationTokenAuthenticator)this.getAuthenticator()).renewDelegationToken(url, token, token.delegationToken, doAsUser);
        }
        catch (IOException ex) {
            token.delegationToken = null;
            throw ex;
        }
    }

    public void cancelDelegationToken(URL url, Token token) throws IOException {
        this.cancelDelegationToken(url, token, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDelegationToken(URL url, Token token, String doAsUser) throws IOException {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)((Object)token), (Object)"token");
        Preconditions.checkNotNull((Object)token.delegationToken, (Object)"No delegation token available");
        try {
            ((KerberosDelegationTokenAuthenticator)this.getAuthenticator()).cancelDelegationToken(url, token, token.delegationToken, doAsUser);
        }
        finally {
            token.delegationToken = null;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class Token
    extends AuthenticatedURL.Token {
        private org.apache.hadoop.security.token.Token<AbstractDelegationTokenIdentifier> delegationToken;

        public org.apache.hadoop.security.token.Token<AbstractDelegationTokenIdentifier> getDelegationToken() {
            return this.delegationToken;
        }

        public void setDelegationToken(org.apache.hadoop.security.token.Token<AbstractDelegationTokenIdentifier> delegationToken) {
            this.delegationToken = delegationToken;
        }
    }
}

