/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.util.DateMathParser;

public class DateFormatEvaluator
extends Evaluator {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected Map<String, Locale> availableLocales = new HashMap<String, Locale>();
    protected Set<String> availableTimezones = new HashSet<String>();

    @SuppressForbidden(reason="Usage of outdated locale parsing with Locale#toString() because of backwards compatibility")
    public DateFormatEvaluator() {
        for (Locale locale : Locale.getAvailableLocales()) {
            this.availableLocales.put(locale.toString(), locale);
        }
        for (String tz : TimeZone.getAvailableIDs()) {
            this.availableTimezones.add(tz);
        }
    }

    private SimpleDateFormat getDateFormat(String pattern, TimeZone timezone, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(timezone);
        return sdf;
    }

    @Override
    public String evaluate(String expression, Context context) {
        List<Object> l = this.parseParams(expression, context.getVariableResolver());
        if (l.size() < 2 || l.size() > 4) {
            throw new DataImportHandlerException(500, "'formatDate()' must have two, three or four parameters ");
        }
        Object o = l.get(0);
        Object format = l.get(1);
        if (format instanceof Evaluator.VariableWrapper) {
            Evaluator.VariableWrapper wrapper = (Evaluator.VariableWrapper)format;
            o = wrapper.resolve();
            format = o.toString();
        }
        Locale locale = Locale.ENGLISH;
        if (l.size() > 2) {
            Object localeObj = l.get(2);
            String localeStr = null;
            localeStr = localeObj instanceof Evaluator.VariableWrapper ? ((Evaluator.VariableWrapper)localeObj).resolve().toString() : localeObj.toString();
            locale = this.availableLocales.get(localeStr);
            if (locale == null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeStr).build();
                }
                catch (IllformedLocaleException ex) {
                    throw new DataImportHandlerException(500, "Malformed / non-existent locale: " + localeStr, ex);
                }
            }
        }
        TimeZone tz = TimeZone.getDefault();
        if (l.size() == 4) {
            Object tzObj = l.get(3);
            String tzStr = null;
            tzStr = tzObj instanceof Evaluator.VariableWrapper ? ((Evaluator.VariableWrapper)tzObj).resolve().toString() : tzObj.toString();
            if (this.availableTimezones.contains(tzStr)) {
                tz = TimeZone.getTimeZone(tzStr);
            } else {
                throw new DataImportHandlerException(500, "Unsupported Timezone: " + tzStr);
            }
        }
        String dateFmt = format.toString();
        SimpleDateFormat fmt = this.getDateFormat(dateFmt, tz, locale);
        Date date = null;
        date = o instanceof Evaluator.VariableWrapper ? this.evaluateWrapper((Evaluator.VariableWrapper)o, locale, tz) : this.evaluateString(o.toString(), locale, tz);
        return fmt.format(date);
    }

    protected Date evaluateWrapper(Evaluator.VariableWrapper variableWrapper, Locale locale, TimeZone tz) {
        Date date = null;
        Object variableval = this.resolveWrapper(variableWrapper, locale, tz);
        if (variableval instanceof Date) {
            date = (Date)variableval;
        } else {
            String s = variableval.toString();
            try {
                date = this.getDateFormat(DEFAULT_DATE_FORMAT, tz, locale).parse(s);
            }
            catch (ParseException exp) {
                DataImportHandlerException.wrapAndThrow(500, exp, "Invalid expression for date");
            }
        }
        return date;
    }

    protected Date evaluateString(String datemathfmt, Locale locale, TimeZone tz) {
        if (datemathfmt.startsWith("NOW")) {
            datemathfmt = datemathfmt.substring("NOW".length());
        }
        try {
            DateMathParser parser = new DateMathParser(tz);
            parser.setNow(new Date());
            return parser.parseMath(datemathfmt);
        }
        catch (ParseException e) {
            throw DataImportHandlerException.wrapAndThrow(500, e, "Invalid expression for date");
        }
    }

    protected Object resolveWrapper(Evaluator.VariableWrapper variableWrapper, Locale locale, TimeZone tz) {
        return variableWrapper.resolve();
    }
}

