/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPChunkerFilter;
import org.apache.lucene.analysis.opennlp.tools.NLPChunkerOp;
import org.apache.lucene.analysis.opennlp.tools.OpenNLPOpsFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class OpenNLPChunkerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "openNlpChunker";
    public static final String CHUNKER_MODEL = "chunkerModel";
    private final String chunkerModelFile;

    public OpenNLPChunkerFilterFactory(Map<String, String> args) {
        super(args);
        this.chunkerModelFile = this.get(args, CHUNKER_MODEL);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public OpenNLPChunkerFilter create(TokenStream in) {
        try {
            NLPChunkerOp chunkerOp = null;
            if (this.chunkerModelFile != null) {
                chunkerOp = OpenNLPOpsFactory.getChunker(this.chunkerModelFile);
            }
            return new OpenNLPChunkerFilter(in, chunkerOp);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void inform(ResourceLoader loader) {
        try {
            if (this.chunkerModelFile != null) {
                OpenNLPOpsFactory.getChunkerModel(this.chunkerModelFile, loader);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

