/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import org.broad.igv.feature.genome.Sequence;

public class ColorSpaceSequence {
    Sequence sequence;

    public ColorSpaceSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public byte[] getSequence(String chr, int start, int end) {
        int i;
        int c1;
        int csStart = start == 0 ? 0 : start - 1;
        byte[] baseSequence = this.sequence.getSequence(chr, csStart, end, true);
        if (baseSequence == null || baseSequence.length == 0) {
            return baseSequence;
        }
        byte[] csSequence = new byte[end - start];
        int n = c1 = start == 0 ? 0 : ColorSpaceSequence.baseToCS(baseSequence[i++]);
        for (i = 0; i < baseSequence.length; ++i) {
            int c2 = ColorSpaceSequence.baseToCS(baseSequence[i]);
            csSequence[i] = (byte)(c1 ^ c2);
        }
        return csSequence;
    }

    private static int baseToCS(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 0;
            }
            case 67: 
            case 99: {
                return 1;
            }
            case 84: 
            case 116: {
                return 2;
            }
            case 71: 
            case 103: {
                return 3;
            }
        }
        return -1;
    }

    public byte getBase(String chr, int position) {
        return 0;
    }
}

