/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.tools.FeatureSearcher;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.CancellableProgressDialog;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.util.LongRunningTask;

class FeatureTrackUtils {
    private static volatile boolean isSearching;

    FeatureTrackUtils() {
    }

    public static Feature nextFeature(FeatureSource source, String chr, int initStart, int initEnd, boolean forward) throws IOException {
        Feature f = null;
        int binSize = source.getFeatureWindowSize();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (forward) {
            int nextStart = initEnd;
            String nextChr = chr;
            while (nextChr != null) {
                int chrLength = genome.getChromosome(nextChr).getLength();
                while (nextStart < chrLength) {
                    int nextEnd = binSize > 0 ? nextStart + source.getFeatureWindowSize() : chrLength;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    if (iter != null) {
                        while (iter.hasNext()) {
                            Feature feat = (Feature)iter.next();
                            if (feat.getStart() <= nextStart) continue;
                            return feat;
                        }
                    }
                    nextStart = nextEnd;
                }
                nextChr = genome.getNextChrName(nextChr);
                nextStart = 0;
            }
        } else {
            int nextEnd = initStart;
            String nextChr = chr;
            while (nextChr != null) {
                while (nextEnd > 0) {
                    int nextStart = binSize > 0 ? Math.max(0, nextEnd - source.getFeatureWindowSize()) : 0;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    if (iter != null && iter.hasNext()) {
                        Feature prevFeature = null;
                        while (iter.hasNext()) {
                            Feature feat = (Feature)iter.next();
                            if (feat.getStart() >= nextEnd) continue;
                            prevFeature = feat;
                        }
                        if (prevFeature != null) {
                            return prevFeature;
                        }
                    }
                    nextEnd = nextStart;
                }
                if ((nextChr = genome.getPrevChrName(nextChr)) == null) continue;
                nextEnd = genome.getChromosome(nextChr).getLength();
            }
        }
        return f;
    }

    public static void nextFeatureSearch(FeatureSource source, String chr, int initStart, int initEnd, boolean forward, final FeatureSearcher.IFeatureFound foundHandler) throws IOException {
        if (FeatureTrackUtils.isSearching()) {
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        int searchIncrement = (initEnd - initStart) * (forward ? 1 : -1);
        int start = initStart + searchIncrement;
        IndefiniteProgressMonitor monitor = new IndefiniteProgressMonitor();
        final FeatureSearcher searcher = new FeatureSearcher(source, genome, chr, start, monitor);
        searcher.setSearchIncrement(searchIncrement);
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                isSearching = false;
                searcher.cancel();
            }
        };
        CancellableProgressDialog dialog = CancellableProgressDialog.showCancellableProgressDialog(IGV.getMainFrame(), "Searching...", cancelListener, true, monitor);
        dialog.getProgressBar().setIndeterminate(true);
        monitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("PROGRESS_PROPERTY") && (Integer)evt.getNewValue() >= 100) {
                    isSearching = false;
                    Iterator<? extends Feature> result = searcher.getResult();
                    if (result != null) {
                        foundHandler.processResult(result);
                    }
                }
            }
        });
        isSearching = true;
        LongRunningTask.submit(searcher);
    }

    private static boolean isSearching() {
        return isSearching;
    }
}

