/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CRAMRecordReadFeatures;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CRAMCompressionRecord {
    private static final Log log = Log.getInstance(CRAMCompressionRecord.class);
    public static final int CF_QS_PRESERVED_AS_ARRAY = 1;
    public static final int CF_DETACHED = 2;
    public static final int CF_HAS_MATE_DOWNSTREAM = 4;
    public static final int CF_UNKNOWN_BASES = 8;
    public static final int NO_READGROUP_ID = -1;
    public static final byte MISSING_QUALITY_SCORE = -1;
    private static final byte DEFAULT_QUALITY_SCORE = 30;
    public static final int MF_MATE_NEG_STRAND = 1;
    public static final int MF_MATE_UNMAPPED = 2;
    private final int referenceIndex;
    private final int alignmentStart;
    private final int alignmentEnd;
    private final int readLength;
    private final CRAMRecordReadFeatures readFeatures;
    private final int mappingQuality;
    private final int readGroupID;
    private final List<ReadTag> tags;
    private final long sequentialIndex;
    private int bamFlags;
    private int cramFlags;
    private int templateSize;
    private String readName;
    private byte[] readBases;
    private byte[] qualityScores;
    private MutableInt tagIdsIndex = new MutableInt(0);
    private int mateFlags;
    private int mateAlignmentStart;
    private int mateReferenceIndex;
    private int recordsToNextFragment = -1;
    private CRAMCompressionRecord nextSegment = null;
    private CRAMCompressionRecord previousSegment = null;
    private boolean isNormalized = false;

    public CRAMCompressionRecord(CRAMVersion cramVersion, CRAMEncodingStrategy encodingStrategy, SAMRecord samRecord, byte[] referenceBases, long sequentialIndex, Map<String, Integer> readGroupMap) {
        ValidationUtils.nonNull(cramVersion);
        ValidationUtils.nonNull(encodingStrategy);
        ValidationUtils.nonNull(samRecord, "a valid SAMRecord is required");
        ValidationUtils.nonNull(samRecord.getHeader(), "SAMRecord must have a valid header");
        ValidationUtils.nonNull(referenceBases != null || !samRecord.getReadUnmappedFlag());
        ValidationUtils.validateArg(sequentialIndex >= 0L, "sequential index must be >= 0");
        ValidationUtils.nonNull(readGroupMap);
        this.sequentialIndex = sequentialIndex;
        this.setToDetachedState();
        this.setMultiFragment(samRecord.getReadPairedFlag());
        this.setProperPair(samRecord.getReadPairedFlag() && samRecord.getProperPairFlag());
        this.setSegmentUnmapped(samRecord.getReadUnmappedFlag());
        this.setFirstSegment(samRecord.getReadPairedFlag() && samRecord.getFirstOfPairFlag());
        this.setLastSegment(samRecord.getReadPairedFlag() && samRecord.getSecondOfPairFlag());
        this.setNegativeStrand(samRecord.getReadNegativeStrandFlag());
        this.setSecondaryAlignment(samRecord.isSecondaryAlignment());
        this.setSupplementary(samRecord.getSupplementaryAlignmentFlag());
        this.setVendorFiltered(samRecord.getReadFailsVendorQualityCheckFlag());
        this.setDuplicate(samRecord.getDuplicateReadFlag());
        this.readName = samRecord.getReadName();
        this.referenceIndex = samRecord.getReferenceIndex();
        this.readLength = samRecord.getReadLength();
        this.alignmentStart = samRecord.getAlignmentStart();
        byte[] originalBases = samRecord.getReadBases();
        byte[] byArray = this.readBases = originalBases == null || originalBases.equals(SAMRecord.NULL_SEQUENCE) ? SAMRecord.NULL_SEQUENCE : SequenceUtil.toBamReadBasesInPlace(Arrays.copyOf(originalBases, samRecord.getReadLength()));
        if (samRecord.getReadUnmappedFlag()) {
            this.readFeatures = new CRAMRecordReadFeatures();
            this.alignmentEnd = 0;
        } else {
            this.readFeatures = new CRAMRecordReadFeatures(samRecord, this.readBases, referenceBases);
            this.alignmentEnd = this.readFeatures.getAlignmentEnd(this.alignmentStart, this.readLength);
        }
        this.templateSize = samRecord.getInferredInsertSize();
        this.mappingQuality = samRecord.getMappingQuality();
        if (samRecord.getReadPairedFlag()) {
            this.mateAlignmentStart = samRecord.getMateAlignmentStart();
            this.setMateUnmapped(samRecord.getMateUnmappedFlag());
            this.setMateNegativeStrand(samRecord.getMateNegativeStrandFlag());
            this.mateReferenceIndex = samRecord.getMateReferenceIndex();
        } else {
            this.mateAlignmentStart = 0;
            this.mateReferenceIndex = -1;
        }
        if (cramVersion.compatibleWith(CramVersions.CRAM_v3)) {
            this.setUnknownBases(samRecord.getReadBases().equals(SAMRecord.NULL_SEQUENCE));
        }
        this.qualityScores = samRecord.getBaseQualities();
        if (!this.qualityScores.equals(SAMRecord.NULL_QUALS)) {
            this.setForcePreserveQualityScores(true);
        } else if (this.readFeatures.getReadFeaturesList().size() > 0) {
            this.qualityScores = new byte[this.readLength];
            Arrays.fill(this.qualityScores, (byte)-1);
            this.setForcePreserveQualityScores(true);
        }
        SAMReadGroupRecord readGroup = samRecord.getReadGroup();
        int n = this.readGroupID = readGroup == null ? -1 : readGroupMap.get(readGroup.getId());
        if (samRecord.getAttributes().size() > 0) {
            this.tags = new ArrayList<ReadTag>();
            for (SAMRecord.SAMTagAndValue tagAndValue : samRecord.getAttributes()) {
                if (SAMTag.RG.name().equals(tagAndValue.tag)) continue;
                this.tags.add(ReadTag.deriveTypeFromValue(tagAndValue.tag, tagAndValue.value));
            }
        } else {
            this.tags = null;
        }
    }

    public CRAMCompressionRecord(long sequentialIndex, int bamFlags, int cramFlags, String readName, int readLength, int referenceIndex, int alignmentStart, int templateSize, int mappingQuality, byte[] qualityScores, byte[] readBases, List<ReadTag> readTags, List<ReadFeature> readFeaturesList, int readGroupID, int mateFlags, int mateReferenceIndex, int mateAlignmentStart, int recordsToNextFragment) {
        ValidationUtils.nonNull(qualityScores, "quality scores argument must be null or nonzero length");
        ValidationUtils.nonNull(readBases, "read bases argument cannot be null");
        ValidationUtils.validateArg(readTags == null || readTags.size() > 0, "invalid read tag argument");
        ValidationUtils.validateArg(readFeaturesList == null || readFeaturesList.size() > 0, "invalid read features argument");
        ValidationUtils.validateArg(sequentialIndex >= 0L, "index must be >= 0");
        this.sequentialIndex = sequentialIndex;
        this.bamFlags = bamFlags;
        this.cramFlags = cramFlags;
        this.readName = readName;
        this.readLength = readLength;
        this.referenceIndex = referenceIndex;
        this.alignmentStart = alignmentStart;
        this.templateSize = templateSize;
        this.mappingQuality = mappingQuality;
        this.qualityScores = qualityScores;
        this.readBases = readBases;
        this.tags = readTags;
        this.readGroupID = readGroupID;
        this.mateFlags = mateFlags;
        this.mateReferenceIndex = mateReferenceIndex;
        this.mateAlignmentStart = mateAlignmentStart;
        this.recordsToNextFragment = recordsToNextFragment;
        this.readFeatures = readFeaturesList == null ? new CRAMRecordReadFeatures() : new CRAMRecordReadFeatures(readFeaturesList);
        this.alignmentEnd = this.isPlaced() ? this.readFeatures.getAlignmentEnd(alignmentStart, readLength) : 0;
    }

    public SAMRecord toSAMRecord(SAMFileHeader samFileHeader) {
        ValidationUtils.nonNull(samFileHeader, "a valid sam header is required");
        ValidationUtils.validateArg(this.isNormalized, "record must be normalized to convert to SAMRecord");
        SAMRecord samRecord = new SAMRecord(samFileHeader);
        samRecord.setReadName(this.readName);
        CRAMCompressionRecord.copyFlags(this, samRecord);
        if (this.referenceIndex == -1) {
            samRecord.setReferenceIndex(-1);
            samRecord.setAlignmentStart(0);
            samRecord.setMappingQuality(0);
        } else {
            samRecord.setReferenceIndex(this.referenceIndex);
            samRecord.setAlignmentStart(this.alignmentStart);
            samRecord.setMappingQuality(this.mappingQuality);
        }
        if (this.isSegmentUnmapped()) {
            samRecord.setCigarString("*");
        } else {
            samRecord.setCigar(this.readFeatures.getCigarForReadFeatures(this.readLength));
        }
        if (samRecord.getReadPairedFlag()) {
            samRecord.setMateReferenceIndex(this.mateReferenceIndex);
            samRecord.setMateAlignmentStart(this.mateAlignmentStart > 0 ? this.mateAlignmentStart : 0);
            samRecord.setMateNegativeStrandFlag(this.isMateNegativeStrand());
            samRecord.setMateUnmappedFlag(this.isMateUnmapped());
        } else {
            samRecord.setMateReferenceIndex(-1);
            samRecord.setMateAlignmentStart(0);
        }
        samRecord.setInferredInsertSize(this.templateSize);
        samRecord.setReadBases(this.readBases);
        samRecord.setBaseQualities(this.qualityScores);
        if (this.tags != null) {
            for (ReadTag tag : this.tags) {
                samRecord.setAttribute(tag.getKey(), tag.getValue());
            }
        }
        if (this.readGroupID != -1) {
            SAMReadGroupRecord readGroupRecord = samFileHeader.getReadGroups().get(this.readGroupID);
            samRecord.setAttribute("RG", (Object)readGroupRecord.getId());
        }
        return samRecord;
    }

    public void assignReadName() {
        if (this.readName == null) {
            this.readName = Long.toString(this.getSequentialIndex());
            if (this.nextSegment != null) {
                this.nextSegment.readName = this.readName;
            }
            if (this.previousSegment != null) {
                this.previousSegment.readName = this.readName;
            }
        }
    }

    void setIsNormalized() {
        this.isNormalized = true;
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void resolveQualityScores() {
        if (!this.isForcePreserveQualityScores()) {
            boolean hasMissingScores = true;
            byte[] scores = new byte[this.readLength];
            Arrays.fill(scores, (byte)30);
            for (ReadFeature feature : this.getReadFeatures()) {
                switch (feature.getOperator()) {
                    case 81: {
                        int pos = feature.getPosition();
                        scores[pos - 1] = ((BaseQualityScore)feature).getQualityScore();
                        hasMissingScores = false;
                        break;
                    }
                    case 66: {
                        int pos = feature.getPosition();
                        scores[pos - 1] = ((ReadBase)feature).getQualityScore();
                        hasMissingScores = false;
                        break;
                    }
                }
            }
            this.qualityScores = hasMissingScores ? SAMRecord.NULL_QUALS : scores;
        } else {
            byte[] scores = this.qualityScores;
            int missingScores = 0;
            for (int i = 0; i < scores.length; ++i) {
                if (scores[i] != -1) continue;
                scores[i] = 30;
                ++missingScores;
            }
            if (missingScores == scores.length) {
                this.qualityScores = SAMRecord.NULL_QUALS;
            }
        }
    }

    private static int computeInsertSize(CRAMCompressionRecord firstEnd, CRAMCompressionRecord secondEnd) {
        if (firstEnd.isSegmentUnmapped() || secondEnd.isSegmentUnmapped() || firstEnd.referenceIndex != secondEnd.referenceIndex) {
            return 0;
        }
        int firstEnd5PrimePosition = firstEnd.isNegativeStrand() ? firstEnd.getAlignmentEnd() : firstEnd.alignmentStart;
        int secondEnd5PrimePosition = secondEnd.isNegativeStrand() ? secondEnd.getAlignmentEnd() : secondEnd.alignmentStart;
        int adjustment = secondEnd5PrimePosition >= firstEnd5PrimePosition ? 1 : -1;
        return secondEnd5PrimePosition - firstEnd5PrimePosition + adjustment;
    }

    public void restoreReadBases(byte[] referenceBases, int zeroBasedReferenceOffset, SubstitutionMatrix substitutionMatrix) {
        this.readBases = this.isUnknownBases() ? SAMRecord.NULL_SEQUENCE : CRAMRecordReadFeatures.restoreReadBases(this.readFeatures == null ? Collections.EMPTY_LIST : this.readFeatures.getReadFeaturesList(), this.isUnknownBases(), this.alignmentStart, this.readLength, referenceBases, zeroBasedReferenceOffset, substitutionMatrix);
    }

    public void restoreMateInfo() {
        int templateLength;
        if (this.getNextSegment() == null) {
            return;
        }
        CRAMCompressionRecord cur = this;
        while (cur.getNextSegment() != null) {
            cur.setNextMate(cur.getNextSegment());
            cur = cur.getNextSegment();
        }
        CRAMCompressionRecord last = cur;
        last.setNextMate(this);
        this.templateSize = templateLength = CRAMCompressionRecord.computeInsertSize(this, last);
        last.templateSize = -templateLength;
    }

    public void setToDetachedState() {
        this.setDetached(true);
        this.setHasMateDownStream(false);
        this.recordsToNextFragment = -1;
    }

    private void setNextMate(CRAMCompressionRecord next) {
        this.mateAlignmentStart = next.alignmentStart;
        this.setMateUnmapped(next.isSegmentUnmapped());
        this.setMateNegativeStrand(next.isNegativeStrand());
        this.mateReferenceIndex = next.referenceIndex;
        if (this.mateReferenceIndex == -1) {
            this.mateAlignmentStart = 0;
        }
    }

    public boolean isPlaced() {
        boolean placed;
        boolean bl = placed = this.alignmentStart != 0;
        if (placed) {
            if (this.referenceIndex == -1) {
                String warning = String.format("CRAMRecord [%s] has an valid alignment start but not a valid reference index.", this.toString());
                log.warn(warning);
            }
        } else if (!this.isSegmentUnmapped()) {
            String warning = String.format("CRAMRecord [%s] appears to be mapped but does not have a valid alignment start.", this.toString());
            log.warn(warning);
        }
        return placed;
    }

    public String getReadName() {
        return this.readName;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getReadLength() {
        return this.readLength;
    }

    public byte[] getReadBases() {
        return this.readBases;
    }

    public byte[] getQualityScores() {
        return this.qualityScores;
    }

    public int getMappingQuality() {
        return this.mappingQuality;
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    public int getTemplateSize() {
        return this.templateSize;
    }

    public List<ReadTag> getTags() {
        return this.tags;
    }

    public int getRecordsToNextFragment() {
        return this.recordsToNextFragment;
    }

    public List<ReadFeature> getReadFeatures() {
        return this.readFeatures == null ? null : this.readFeatures.getReadFeaturesList();
    }

    public int getReadGroupID() {
        return this.readGroupID;
    }

    public int getBAMFlags() {
        return this.bamFlags;
    }

    public int getMateReferenceIndex() {
        return this.mateReferenceIndex;
    }

    public int getMateAlignmentStart() {
        return this.mateAlignmentStart;
    }

    public void setTagIdsIndex(MutableInt tagIdsIndex) {
        this.tagIdsIndex = tagIdsIndex;
    }

    public MutableInt getTagIdsIndex() {
        return this.tagIdsIndex;
    }

    public int getMateFlags() {
        return 0xFF & this.mateFlags;
    }

    public int getCRAMFlags() {
        return 0xFF & this.cramFlags;
    }

    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    public long getSequentialIndex() {
        return this.sequentialIndex;
    }

    public CRAMCompressionRecord getNextSegment() {
        return this.nextSegment;
    }

    public void setNextSegment(CRAMCompressionRecord nextSegment) {
        this.nextSegment = nextSegment;
    }

    public CRAMCompressionRecord getPreviousSegment() {
        return this.previousSegment;
    }

    public void setPreviousSegment(CRAMCompressionRecord previousSegment) {
        this.previousSegment = previousSegment;
    }

    public boolean isSecondaryAlignment() {
        return (this.bamFlags & SAMFlag.SECONDARY_ALIGNMENT.intValue()) != 0;
    }

    private void setSecondaryAlignment(boolean secondaryAlignment) {
        this.bamFlags = secondaryAlignment ? this.bamFlags | SAMFlag.SECONDARY_ALIGNMENT.intValue() : this.bamFlags & ~SAMFlag.SECONDARY_ALIGNMENT.intValue();
    }

    public boolean isHasMateDownStream() {
        return CRAMCompressionRecord.isHasMateDownStream(this.cramFlags);
    }

    public static boolean isHasMateDownStream(int cramFlags) {
        return (cramFlags & 4) != 0;
    }

    public boolean isDetached() {
        return CRAMCompressionRecord.isDetached(this.cramFlags);
    }

    public static boolean isDetached(int cramFlags) {
        return (cramFlags & 2) != 0;
    }

    public boolean isForcePreserveQualityScores() {
        return CRAMCompressionRecord.isForcePreserveQualityScores(this.cramFlags);
    }

    public static boolean isForcePreserveQualityScores(int cramFlags) {
        return (cramFlags & 1) != 0;
    }

    public boolean isUnknownBases() {
        return CRAMCompressionRecord.isUnknownBases(this.cramFlags);
    }

    public static boolean isUnknownBases(int cramFlags) {
        return (cramFlags & 8) != 0;
    }

    public boolean isReadPaired() {
        return (this.bamFlags & SAMFlag.READ_PAIRED.intValue()) != 0;
    }

    private void setMultiFragment(boolean multiFragment) {
        this.bamFlags = multiFragment ? this.bamFlags | SAMFlag.READ_PAIRED.intValue() : this.bamFlags & ~SAMFlag.READ_PAIRED.intValue();
    }

    public boolean isSegmentUnmapped() {
        return CRAMCompressionRecord.isSegmentUnmapped(this.bamFlags);
    }

    public static boolean isSegmentUnmapped(int bamFlags) {
        return (bamFlags & SAMFlag.READ_UNMAPPED.intValue()) != 0;
    }

    private void setSegmentUnmapped(boolean segmentUnmapped) {
        this.bamFlags = segmentUnmapped ? this.bamFlags | SAMFlag.READ_UNMAPPED.intValue() : this.bamFlags & ~SAMFlag.READ_UNMAPPED.intValue();
    }

    public boolean isFirstSegment() {
        return (this.bamFlags & SAMFlag.FIRST_OF_PAIR.intValue()) != 0;
    }

    private void setFirstSegment(boolean firstSegment) {
        this.bamFlags = firstSegment ? this.bamFlags | SAMFlag.FIRST_OF_PAIR.intValue() : this.bamFlags & ~SAMFlag.FIRST_OF_PAIR.intValue();
    }

    public boolean isLastSegment() {
        return (this.bamFlags & SAMFlag.SECOND_OF_PAIR.intValue()) != 0;
    }

    private void setLastSegment(boolean lastSegment) {
        this.bamFlags = lastSegment ? this.bamFlags | SAMFlag.SECOND_OF_PAIR.intValue() : this.bamFlags & ~SAMFlag.SECOND_OF_PAIR.intValue();
    }

    private boolean isVendorFiltered() {
        return (this.bamFlags & SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.intValue()) != 0;
    }

    private void setVendorFiltered(boolean vendorFiltered) {
        this.bamFlags = vendorFiltered ? this.bamFlags | SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.intValue() : this.bamFlags & ~SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.intValue();
    }

    private boolean isProperPair() {
        return (this.bamFlags & SAMFlag.PROPER_PAIR.intValue()) != 0;
    }

    private void setProperPair(boolean properPair) {
        this.bamFlags = properPair ? this.bamFlags | SAMFlag.PROPER_PAIR.intValue() : this.bamFlags & ~SAMFlag.PROPER_PAIR.intValue();
    }

    private boolean isDuplicate() {
        return (this.bamFlags & SAMFlag.DUPLICATE_READ.intValue()) != 0;
    }

    private void setDuplicate(boolean duplicate) {
        this.bamFlags = duplicate ? this.bamFlags | SAMFlag.DUPLICATE_READ.intValue() : this.bamFlags & ~SAMFlag.DUPLICATE_READ.intValue();
    }

    private boolean isNegativeStrand() {
        return (this.bamFlags & SAMFlag.READ_REVERSE_STRAND.intValue()) != 0;
    }

    private void setNegativeStrand(boolean negativeStrand) {
        this.bamFlags = negativeStrand ? this.bamFlags | SAMFlag.READ_REVERSE_STRAND.intValue() : this.bamFlags & ~SAMFlag.READ_REVERSE_STRAND.intValue();
    }

    private boolean isMateUnmapped() {
        return (this.mateFlags & 2) != 0;
    }

    private void setMateUnmapped(boolean mateUnmapped) {
        this.mateFlags = mateUnmapped ? this.mateFlags | 2 : this.mateFlags & 0xFFFFFFFD;
        this.bamFlags = mateUnmapped ? this.bamFlags | SAMFlag.MATE_UNMAPPED.intValue() : this.bamFlags & ~SAMFlag.MATE_UNMAPPED.intValue();
    }

    private boolean isMateNegativeStrand() {
        return (this.mateFlags & 1) != 0;
    }

    private void setMateNegativeStrand(boolean mateNegativeStrand) {
        this.mateFlags = mateNegativeStrand ? this.mateFlags | 1 : this.mateFlags & 0xFFFFFFFE;
        this.bamFlags = mateNegativeStrand ? this.bamFlags | SAMFlag.MATE_REVERSE_STRAND.intValue() : this.bamFlags & ~SAMFlag.MATE_REVERSE_STRAND.intValue();
    }

    private void setHasMateDownStream(boolean hasMateDownStream) {
        this.cramFlags = hasMateDownStream ? this.cramFlags | 4 : this.cramFlags & 0xFFFFFFFB;
    }

    public void setDetached(boolean detached) {
        this.cramFlags = detached ? this.cramFlags | 2 : this.cramFlags & 0xFFFFFFFD;
    }

    private void setUnknownBases(boolean unknownBases) {
        this.cramFlags = unknownBases ? this.cramFlags | 8 : this.cramFlags & 0xFFFFFFF7;
    }

    private boolean isSupplementary() {
        return (this.bamFlags & SAMFlag.SUPPLEMENTARY_ALIGNMENT.intValue()) != 0;
    }

    private void setSupplementary(boolean supplementary) {
        this.bamFlags = supplementary ? this.bamFlags | SAMFlag.SUPPLEMENTARY_ALIGNMENT.intValue() : this.bamFlags & ~SAMFlag.SUPPLEMENTARY_ALIGNMENT.intValue();
    }

    private void setForcePreserveQualityScores(boolean forcePreserveQualityScores) {
        this.cramFlags = forcePreserveQualityScores ? this.cramFlags | 1 : this.cramFlags & 0xFFFFFFFE;
    }

    private static void copyFlags(CRAMCompressionRecord cramCompressionRecord, SAMRecord samRecord) {
        samRecord.setReadPairedFlag(cramCompressionRecord.isReadPaired());
        samRecord.setProperPairFlag(cramCompressionRecord.isProperPair());
        samRecord.setReadUnmappedFlag(cramCompressionRecord.isSegmentUnmapped());
        samRecord.setReadNegativeStrandFlag(cramCompressionRecord.isNegativeStrand());
        samRecord.setFirstOfPairFlag(cramCompressionRecord.isFirstSegment());
        samRecord.setSecondOfPairFlag(cramCompressionRecord.isLastSegment());
        samRecord.setSecondaryAlignment(cramCompressionRecord.isSecondaryAlignment());
        samRecord.setReadFailsVendorQualityCheckFlag(cramCompressionRecord.isVendorFiltered());
        samRecord.setDuplicateReadFlag(cramCompressionRecord.isDuplicate());
        samRecord.setSupplementaryAlignmentFlag(cramCompressionRecord.isSupplementary());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRAMCompressionRecord that = (CRAMCompressionRecord)o;
        if (this.getAlignmentStart() != that.getAlignmentStart()) {
            return false;
        }
        if (this.getReadLength() != that.getReadLength()) {
            return false;
        }
        if (this.getAlignmentEnd() != that.getAlignmentEnd()) {
            return false;
        }
        if (this.getReferenceIndex() != that.getReferenceIndex()) {
            return false;
        }
        if (this.getMappingQuality() != that.getMappingQuality()) {
            return false;
        }
        if (this.getReadGroupID() != that.getReadGroupID()) {
            return false;
        }
        if (this.getBAMFlags() != that.getBAMFlags()) {
            return false;
        }
        if (this.getCRAMFlags() != that.getCRAMFlags()) {
            return false;
        }
        if (this.getTemplateSize() != that.getTemplateSize()) {
            return false;
        }
        if (this.getMateFlags() != that.getMateFlags()) {
            return false;
        }
        if (this.getMateAlignmentStart() != that.getMateAlignmentStart()) {
            return false;
        }
        if (this.getMateReferenceIndex() != that.getMateReferenceIndex()) {
            return false;
        }
        if (this.getRecordsToNextFragment() != that.getRecordsToNextFragment()) {
            return false;
        }
        if (this.getReadFeatures() != null ? !this.getReadFeatures().equals(that.getReadFeatures()) : that.getReadFeatures() != null) {
            return false;
        }
        if (this.getTags() != null ? !this.getTags().equals(that.getTags()) : that.getTags() != null) {
            return false;
        }
        if (this.getReadName() != null ? !this.getReadName().equals(that.getReadName()) : that.getReadName() != null) {
            return false;
        }
        if (!Arrays.equals(this.getReadBases(), that.getReadBases())) {
            return false;
        }
        if (!Arrays.equals(this.getQualityScores(), that.getQualityScores())) {
            return false;
        }
        if (!this.getTagIdsIndex().equals(that.getTagIdsIndex())) {
            return false;
        }
        if (this.getNextSegment() != null ? !this.getNextSegment().equals(that.getNextSegment()) : that.getNextSegment() != null) {
            return false;
        }
        return this.getPreviousSegment() != null ? this.getPreviousSegment().equals(that.getPreviousSegment()) : that.getPreviousSegment() == null;
    }

    public int hashCode() {
        int result = this.getAlignmentStart();
        result = 31 * result + this.getReadLength();
        result = 31 * result + (this.getReadFeatures() != null ? this.getReadFeatures().hashCode() : 0);
        result = 31 * result + this.getAlignmentEnd();
        result = 31 * result + this.getReferenceIndex();
        result = 31 * result + this.getMappingQuality();
        result = 31 * result + this.getReadGroupID();
        result = 31 * result + (this.getTags() != null ? this.getTags().hashCode() : 0);
        result = 31 * result + Long.hashCode(this.getSequentialIndex());
        result = 31 * result + this.getBAMFlags();
        result = 31 * result + this.cramFlags;
        result = 31 * result + this.getTemplateSize();
        result = 31 * result + (this.getReadName() != null ? this.getReadName().hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.getReadBases());
        result = 31 * result + Arrays.hashCode(this.getQualityScores());
        result = 31 * result + (this.getTagIdsIndex() != null ? this.getTagIdsIndex().hashCode() : 0);
        result = 31 * result + this.getMateFlags();
        result = 31 * result + this.getMateAlignmentStart();
        result = 31 * result + this.getMateReferenceIndex();
        result = 31 * result + this.getRecordsToNextFragment();
        result = 31 * result + (this.getNextSegment() != null ? this.getNextSegment().hashCode() : 0);
        result = 31 * result + (this.getPreviousSegment() != null ? this.getPreviousSegment().hashCode() : 0);
        return result;
    }
}

