/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.handlers;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.messages.GetFileContentNotification;
import com.jetbrains.php.debug.zend.messages.SendFileContentNotification;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GetFileContentNotificationHandler
extends InputHandler<GetFileContentNotification> {
    private static final byte[] EMPTY_FILE_CONTENT = new byte[0];
    private final PhpDebugProcess<? extends ZendDebuggerConnection> myDebugProcess;

    public <S extends ZendDebuggerConnection> GetFileContentNotificationHandler(PhpDebugProcess<S> debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    @Override
    public void onResponse(@NotNull GetFileContentNotification message) {
        VirtualFile localFile;
        if (message == null) {
            GetFileContentNotificationHandler.$$$reportNull$$$0(0);
        }
        int param1 = message.getParam1();
        String remoteFileName = message.getFileName();
        PhpPathMapper pathMapper = this.myDebugProcess.getPathMapper();
        if (pathMapper != null && (localFile = pathMapper.getLocalFile(remoteFileName)) != null) {
            try {
                byte[] fileContent = localFile.contentsToByteArray();
                this.myDebugProcess.getConnection().send(new SendFileContentNotification(param1, 0, fileContent));
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myDebugProcess.getConnection().send(new SendFileContentNotification(param1, 0, EMPTY_FILE_CONTENT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/handlers/GetFileContentNotificationHandler", "onResponse"));
    }
}

