/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpNonStrictObjectEqualityQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNonStrictObjectEqualityInspection
extends PhpInspection {
    private static final String WARNING_KEY = "inspection.non.strict.object.equality";
    private static final PhpType DATETIME = PhpType.builder().add("\\DateTime").build();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNonStrictObjectEqualityInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpBinaryExpression(@NotNull BinaryExpression element) {
                IElementType[] operations;
                PsiElement operation;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpPsiUtil.isOfType(operation = element.getOperation(), operations = new IElementType[]{PhpTokenTypes.opEQUAL, PhpTokenTypes.opNOT_EQUAL})) {
                    PsiElement left = element.getLeftOperand();
                    PsiElement right = element.getRightOperand();
                    if (!PhpPsiUtil.isOfType(right, PhpElementTypes.NUMBER, PhpElementTypes.STRING) && !PhpPsiUtil.isOfType(left, PhpElementTypes.NUMBER, PhpElementTypes.STRING) && PhpNonStrictObjectEqualityInspection.isObject(left) && PhpNonStrictObjectEqualityInspection.isObject(right)) {
                        String warning = PhpBundle.message(PhpNonStrictObjectEqualityInspection.WARNING_KEY, new Object[0]);
                        holder.registerProblem(operation, warning, new LocalQuickFix[]{PhpNonStrictObjectEqualityQuickFix.INSTANCE});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/probablyBug/PhpNonStrictObjectEqualityInspection$1", "visitPhpBinaryExpression"));
            }
        };
        if (phpElementVisitor == null) {
            PhpNonStrictObjectEqualityInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isObject(@Nullable PsiElement element) {
        if (element instanceof PhpTypedElement) {
            Project project = element.getProject();
            PhpType type = ((PhpTypedElement)element).getType().global(project).filterNull().filterUnknown();
            PhpType typeNoPrimitiveAndPlural = type.filterPrimitives().filterPlurals();
            if (!typeNoPrimitiveAndPlural.isEmpty()) {
                boolean containsPrimitiveOrPlural;
                boolean bl = containsPrimitiveOrPlural = type.size() - typeNoPrimitiveAndPlural.size() > 0;
                if (containsPrimitiveOrPlural) {
                    return false;
                }
                return !DATETIME.isConvertibleFrom(type, PhpIndex.getInstance((Project)project));
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpNonStrictObjectEqualityInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpNonStrictObjectEqualityInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

