/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseImportQuickFix<E extends PhpNamedElement>
extends PhpQuickFixBase {
    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PhpReference classReference;
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(1);
        }
        if ((classReference = PhpBaseImportQuickFix.getReference(element = descriptor.getPsiElement())) == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scopeForUseOperator == null) {
            return;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            this.showIsInDumpModeMessage(project, element);
            return;
        }
        Collection<E> candidates = this.getCandidates(project, classReference);
        if (candidates.isEmpty()) {
            PhpBaseImportQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.import.base.no.candidates", new Object[0]), element);
            return;
        }
        if (candidates.size() > 1) {
            Editor editor = PsiUtilBase.findEditor((PsiElement)classReference);
            if (editor == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.applyFix(project, classReference, (PhpNamedElement)candidates.iterator().next());
                return;
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])this.toArray(candidates), (PsiElementListCellRenderer)new PsiElementListCellRenderer<E>(){

                public String getElementText(E element1) {
                    return PhpLangUtil.toPresentableFQN(element1.getFQN());
                }

                @Nullable
                protected String getContainerText(E element1, String name) {
                    return null;
                }

                protected int getIconFlags() {
                    return 0;
                }
            }, (String)this.getImportPopupTitle(), (PsiElementProcessor)new PsiElementProcessor<E>(){

                public boolean execute(@NotNull E element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (project == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (element == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            if (project == null) {
                                2.$$$reportNull$$$0(3);
                            }
                            if (element == null) {
                                2.$$$reportNull$$$0(4);
                            }
                            PhpBaseImportQuickFix.this.applyFix(project, classReference, element);
                        });
                    }, this.getClass().getName(), (Object)this);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "execute";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$execute$1";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).showInBestPositionFor(editor);
        } else if (candidates.size() == 1) {
            this.applyFix(project, classReference, (PhpNamedElement)candidates.iterator().next());
        }
    }

    @Nullable
    public static PhpReference getReference(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(2);
        }
        if (!((parent = element.getParent()) instanceof PhpReference)) {
            return null;
        }
        return (PhpReference)parent;
    }

    @NotNull
    protected abstract String getImportPopupTitle();

    protected abstract E[] toArray(@NotNull Collection<E> var1);

    public void applyFix(@NotNull Project project, @NotNull PhpReference classReference, @NotNull E definition) {
        String fqn;
        if (project == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(3);
        }
        if (classReference == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(4);
        }
        if (definition == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(5);
        }
        if (!PhpLangUtil.isFqn(fqn = definition.getFQN())) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scopeForUseOperator == null) {
            return;
        }
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)classReference);
        if (useList != null && !useList.isTraitImport()) {
            PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
            if (namespaceReference == null) {
                this.replaceReference(project, classReference, fqn);
            } else {
                String globalName = PhpLangUtil.toFQN(namespaceReference.getFullName());
                if (fqn.startsWith(globalName)) {
                    this.replaceReference(project, classReference, fqn.substring(globalName.length()));
                } else {
                    this.importIfNeeded(scopeForUseOperator, fqn);
                    PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition((PsiElement)classReference, true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                    PhpCodeEditUtil.deleteUseOrUseList(use, useList);
                }
            }
        } else {
            this.importIfNeeded(scopeForUseOperator, fqn);
        }
    }

    private void importIfNeeded(@NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn) {
        String alias;
        if (scopeForUseOperator == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            PhpBaseImportQuickFix.$$$reportNull$$$0(7);
        }
        if (!PhpLangUtil.equalsClassNames(alias = PhpCodeInsightUtil.alreadyImported(scopeForUseOperator, fqn), PhpLangUtil.toShortName(fqn))) {
            PhpAliasImporter.insertUseStatementWithKeyword(this.getImportKeyword(), fqn, null, scopeForUseOperator);
        }
    }

    @Nullable
    protected abstract String getImportKeyword();

    protected abstract void replaceReference(@NotNull Project var1, @NotNull PhpReference var2, @NotNull String var3);

    @NotNull
    public abstract Collection<E> getCandidates(@NotNull Project var1, @NotNull PhpReference var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpBaseImportQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "importIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

