/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpFieldIntroducePanel;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceVariableIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldHandler;
import com.jetbrains.php.refactoring.introduce.introduceField.PhpIntroduceFieldSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInplaceFieldIntroducer
extends PhpInplaceVariableIntroducer {
    private static final String LAST_SELECTED_INIT_PLACE = PhpInplaceFieldIntroducer.class.getName() + ".lastSelectedInitPlace";
    @Nullable
    private final PhpFieldIntroducePanel myPanel;
    protected final SmartPsiElementPointer<PsiElement> myTarget;
    protected final PhpIntroduceContext myIntroduceContext;
    private final PhpIntroduceFieldSettings mySettings;

    public PhpInplaceFieldIntroducer(PhpIntroduceContext context, PhpIntroduceFieldSettings settings, PsiNamedElement element, PsiElement target) {
        super(element, context, "Introduce Field");
        this.mySettings = settings;
        this.myIntroduceContext = context;
        this.myTarget = SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(target);
        this.myPanel = this.createPanel();
    }

    @Nullable
    protected PhpFieldIntroducePanel createPanel() {
        boolean allowInitInConstructor = PhpInplaceFieldIntroducer.allowInitInConstructor(this.myIntroduceContext);
        boolean allowInitInFieldDeclaration = PhpInplaceFieldIntroducer.allowInitInFieldDeclaration(this.myIntroduceContext);
        boolean allowInitInSetUp = PhpInplaceFieldIntroducer.allowInitInSetUp(this.myIntroduceContext);
        return allowInitInConstructor || allowInitInFieldDeclaration || allowInitInSetUp ? new PhpFieldIntroducePanel(this.myProject, allowInitInFieldDeclaration, allowInitInConstructor, allowInitInSetUp, this.mySettings.getInitPlace()) : null;
    }

    public static boolean allowInitInFieldDeclaration(@NotNull PhpIntroduceContext introduceContext) {
        PsiElement initValue;
        if (introduceContext == null) {
            PhpInplaceFieldIntroducer.$$$reportNull$$$0(0);
        }
        return (initValue = introduceContext.getInitializeValue()) == null || PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(initValue);
    }

    public static boolean allowInitInConstructor(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpInplaceFieldIntroducer.$$$reportNull$$$0(1);
        }
        PsiElement initValue = introduceContext.getInitializeValue();
        boolean isStatic = PhpIntroduceFieldHandler.isStaticContext(introduceContext.getContext());
        boolean isMethodConstructor = introduceContext.getContext() instanceof Method && PhpRefactoringUtil.isConstructor((Method)introduceContext.getContext());
        return !isStatic && !isMethodConstructor && (initValue == null || !PhpRefactoringUtil.containsLocalVariables(initValue));
    }

    public static boolean allowInitInSetUp(PhpIntroduceContext introduceContext) {
        PsiElement scope = introduceContext.getScope();
        return scope instanceof PhpClass && PhpUnitUtil.isTestClass((PhpClass)scope);
    }

    @Override
    protected void adjustCaret(PsiElement elementToSelect) {
        PhpInplaceFieldIntroducer.adjustCaretForReference(elementToSelect, this.myEditor);
    }

    public static void adjustCaretForReference(PsiElement elementToSelect, Editor editor) {
        PsiReference referenceAtCaret = (PsiReference)ObjectUtils.tryCast((Object)elementToSelect, PhpReference.class);
        if (referenceAtCaret != null) {
            PsiElement element = referenceAtCaret.getElement();
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(editor, element, PhpRefactoringUtil.getVariableIdentifierRange(referenceAtCaret.getRangeInElement(), element));
        } else {
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(editor, elementToSelect, elementToSelect.getTextRange());
        }
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Nullable
    public static PhpIntroduceFieldSettings.InitPlace getLastSelectedInitPlace(@NotNull Project project) {
        if (project == null) {
            PhpInplaceFieldIntroducer.$$$reportNull$$$0(2);
        }
        return PhpIntroduceFieldSettings.InitPlace.fromString(PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_INIT_PLACE));
    }

    protected void moveOffsetAfter(boolean success) {
        if (this.myPanel == null) {
            return;
        }
        PhpIntroduceFieldSettings.InitPlace initPlace = this.myPanel.getInitPlace();
        if (success && initPlace != this.mySettings.getInitPlace()) {
            if (initPlace == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION) {
                this.putDeclarationInField();
            } else {
                this.putDeclarationInMethod(initPlace);
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_INIT_PLACE, initPlace.toString());
        }
    }

    private void putDeclarationInField() {
        String name;
        Object field;
        AssignmentExpression initializer = (AssignmentExpression)PsiTreeUtil.findChildOfType((PsiElement)this.myTarget.getElement(), AssignmentExpression.class);
        PhpClass clazz = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)initializer, PhpClass.class);
        if (clazz == null || !clazz.isValid()) {
            return;
        }
        PhpPsiElement createdVariable = initializer.getVariable();
        if (createdVariable != null && (field = PhpPsiUtil.getParentByCondition((PsiElement)clazz.findOwnFieldByName((CharSequence)(name = createdVariable.getName()), false), (Condition<? super PsiElement>)((Condition)f -> PhpPsiUtil.isOfType(f, PhpElementTypes.CLASS_FIELDS)))) != null) {
            WriteAction.run(() -> {
                field.replace(PhpIntroduceFieldHandler.getFieldDeclaration(this.myIntroduceContext, this.mySettings, true, name));
                initializer.getParent().delete();
            });
        }
    }

    private void putDeclarationInMethod(PhpIntroduceFieldSettings.InitPlace initPlace) {
        if (this.mySettings.getInitPlace() == PhpIntroduceFieldSettings.InitPlace.FIELD_DECLARATION) {
            Field field = (Field)ObjectUtils.tryCast((Object)this.myTarget.getElement(), Field.class);
            if (field != null) {
                String name = field.getName();
                Statement initStatement = PhpIntroduceFieldHandler.getFieldInitialization(this.myIntroduceContext, this.mySettings.isStatic(), name);
                WriteAction.run(() -> {
                    PhpIntroduceFieldHandler.putInitStatementInMethodBlock(initPlace, initStatement, this.myIntroduceContext, this.mySettings);
                    Object classFields = PhpPsiUtil.getParentByCondition((PsiElement)field, (Condition<? super PsiElement>)((Condition)f -> PhpPsiUtil.isOfType(f, PhpElementTypes.CLASS_FIELDS)));
                    if (classFields != null) {
                        classFields.replace(PhpIntroduceFieldHandler.getFieldDeclaration(this.myIntroduceContext, this.mySettings, false, name));
                    }
                });
            }
        } else {
            PhpPsiElement createdVariable;
            AssignmentExpression initializer = (AssignmentExpression)PsiTreeUtil.findChildOfType((PsiElement)this.myTarget.getElement(), AssignmentExpression.class);
            PhpPsiElement phpPsiElement = createdVariable = initializer != null ? initializer.getVariable() : null;
            if (createdVariable != null) {
                Statement initStatement = PhpIntroduceFieldHandler.getFieldInitialization(this.myIntroduceContext, this.mySettings.isStatic(), createdVariable.getName());
                WriteAction.run(() -> {
                    PhpIntroduceFieldHandler.putInitStatementInMethodBlock(initPlace, initStatement, this.myIntroduceContext, this.mySettings);
                    initializer.getParent().delete();
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/introduce/inplace/PhpInplaceFieldIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "allowInitInFieldDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "allowInitInConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastSelectedInitPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

