/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.tools.quality.CustomRulesSetupDialog;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSCustomRulesSetupDialog
extends CustomRulesSetupDialog {
    private static final String RULE_SET_FILE = "ruleset.xml";

    protected PhpCSCustomRulesSetupDialog(@Nullable Project project, @Nullable PhpInterpreter interpreter, @NotNull Component parent, @NotNull String rulesetPath) {
        if (parent == null) {
            PhpCSCustomRulesSetupDialog.$$$reportNull$$$0(0);
        }
        if (rulesetPath == null) {
            PhpCSCustomRulesSetupDialog.$$$reportNull$$$0(1);
        }
        super(project, interpreter, parent, rulesetPath, true);
    }

    @Override
    protected boolean containsRulesetXml(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return file.isDirectory() ? ContainerUtil.exists((Object[])file.getChildren(), child -> RULE_SET_FILE.equals(child.getName())) : PhpCSCustomRulesSetupDialog.isCodingStandardFile(file.getPath());
    }

    @Override
    @Nullable
    protected ValidationInfo validatePath(String path) {
        if (path == null || path.isEmpty()) {
            return new ValidationInfo(PhpBundle.message("quality.tool.path.must.not.be.empty", new Object[0]), (JComponent)this.myTopPanel);
        }
        if (!this.myIsRemote) {
            File physicalFile = new File(path);
            if (!physicalFile.exists()) {
                return new ValidationInfo(PhpBundle.message("quality.tool.file.not.found", new Object[0]), (JComponent)this.myTopPanel);
            }
            if (physicalFile.isDirectory()) {
                if (!this.containsRulesetXml(VfsUtil.findFileByIoFile((File)physicalFile, (boolean)true))) {
                    return new ValidationInfo(PhpBundle.message("quality.tool.php.dir.does.not.contain", RULE_SET_FILE));
                }
            } else if (!PhpCSCustomRulesSetupDialog.isCodingStandardFile(path)) {
                return new ValidationInfo(PhpBundle.message("quality.tool.phpcs.custom.rules.validation.not.xml", new Object[0]));
            }
        }
        return null;
    }

    public static boolean isCodingStandardFile(@NotNull String path) {
        String extension;
        if (path == null) {
            PhpCSCustomRulesSetupDialog.$$$reportNull$$$0(2);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)(extension = FileUtilRt.getExtension((String)path)), (CharSequence)"xml") || StringUtil.equalsIgnoreCase((CharSequence)extension, (CharSequence)"dist");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesetPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSCustomRulesSetupDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCodingStandardFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

