/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.framework.FrameworkInfoPopupTypedHandler;
import com.jetbrains.php.framework.completion.FrameworkCompletionContributor;
import com.jetbrains.php.framework.completion.FrameworkLookupElement;
import com.jetbrains.php.framework.data.FrameworkCommand;
import org.jetbrains.annotations.NotNull;

public class FrameworkCommandLookupElement
extends LookupElement
implements FrameworkLookupElement {
    private final FrameworkCommand myCommand;
    private final String myPatternText;
    private final PsiFile myPsiFile;

    public FrameworkCommandLookupElement(FrameworkCommand command, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(0);
        }
        this.myCommand = command;
        this.myPatternText = FrameworkCompletionContributor.getParamsDescription(command, false, -1);
        this.myPsiFile = psiFile;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getTitleForHelp() {
        String string = this.myCommand.getAliasedBasicText();
        if (string == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getHelp() {
        return this.myCommand.getHelp();
    }

    @Override
    @NotNull
    public String getCommandForHelp() {
        String string = this.getLookupString().trim();
        if (string == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getLookupString() {
        if (this.myCommand.getParameters().isEmpty()) {
            String string = this.myCommand.getAliasedBasicText();
            if (string == null) {
                FrameworkCommandLookupElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.myCommand.getAliasedBasicText() + " ";
        if (string == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public FrameworkCommand getCommand() {
        return this.myCommand;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.myCommand.getAliasedBasicText());
        presentation.setTailText(this.myPatternText, true);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            FrameworkCommandLookupElement.$$$reportNull$$$0(6);
        }
        Editor editor = context.getEditor();
        FrameworkCompletionContributor.destroyInfoPopup(editor);
        FrameworkInfoPopupTypedHandler.showInfoPopup(editor.getDocument().getText(), editor, this.myCommand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/completion/FrameworkCommandLookupElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkCommandLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForHelp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandForHelp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

