/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.lang.javascript.flow.FlowJSCliService;
import com.intellij.lang.javascript.flow.Location;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.SemVer;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B!\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00102\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JF\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u001a\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/flow/FlowJSErrorsParser;", "", "targetFilePath", "", "baseDirectoryPath", "json", "Lcom/google/gson/JsonObject;", "(Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "results", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "getResults", "()Ljava/util/List;", "useOldFormat", "", "addChildren", "", "extra", "Lcom/google/gson/JsonArray;", "errorDetails", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addLinkOpenTag", "location", "Lcom/intellij/lang/javascript/flow/Location;", "addMessage", "errorText", "messageObject", "addLink", "isFirstMessage", "severalMessagesInRow", "parseFlowError", "Lcom/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult;", "errorObject", "parseLocation", "Companion", "intellij.javascript.impl"})
public final class FlowJSErrorsParser {
    @NotNull
    private final List<JSAnnotationError> results;
    private final boolean useOldFormat;
    private final String targetFilePath;
    private final String baseDirectoryPath;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<JSAnnotationError> getResults() {
        return this.results;
    }

    private final JSLanguageServiceAnnotationResult parseFlowError(JsonObject errorObject) {
        StringBuilder errorText = new StringBuilder();
        StringBuilder errorDetails = new StringBuilder();
        JsonElement jsonElement = errorObject.get("level");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"errorObject.get(\"level\")");
        String errorCategory = jsonElement.getAsString();
        Location mainLocation = null;
        JsonArray messageArray = errorObject.getAsJsonArray("message");
        boolean isFirstMessage = true;
        for (JsonElement message : messageArray) {
            JsonObject messageObject;
            if (isFirstMessage) {
                errorDetails.append("Flow: ");
            }
            JsonElement jsonElement2 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"message");
            JsonObject jsonObject = messageObject = jsonElement2.getAsJsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"messageObject");
            Location location = this.addMessage(errorText, errorDetails, jsonObject, false, isFirstMessage, messageArray.size() > 1);
            JsonElement jsonElement3 = messageObject.get("type");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"messageObject.get(\"type\")");
            if (Intrinsics.areEqual((Object)jsonElement3.getAsString(), (Object)"Blame") && mainLocation == null && location != null) {
                mainLocation = location;
            }
            isFirstMessage = false;
        }
        if (this.targetFilePath != null && mainLocation != null && !FileUtil.pathsEqual((String)this.targetFilePath, (String)mainLocation.getFilePath())) {
            return null;
        }
        JsonArray extra = errorObject.getAsJsonArray("extra");
        if (extra != null) {
            errorDetails.append("<br/>");
            this.addChildren(extra, errorDetails);
        }
        Location location = mainLocation;
        Location location2 = mainLocation;
        Location location3 = mainLocation;
        Location location4 = mainLocation;
        Location location5 = mainLocation;
        return new JSLanguageServiceAnnotationResult(errorText.toString(), errorDetails.toString(), location != null ? location.getFilePath() : null, errorCategory, location2 != null ? location2.getLine() : 0, location3 != null ? location3.getColumn() : 0, location4 != null ? location4.getLineEnd() : 0, location5 != null ? location5.getColumnEnd() : 0);
    }

    private final Location addMessage(StringBuilder errorText, StringBuilder errorDetails, JsonObject messageObject, boolean addLink, boolean isFirstMessage, boolean severalMessagesInRow) {
        Location location;
        block7: {
            JsonElement jsonElement = messageObject.get("descr");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"messageObject.get(\"descr\")");
            String descr = jsonElement.getAsString();
            location = this.parseLocation(messageObject);
            if (!isFirstMessage) {
                errorDetails.append(' ');
                StringBuilder stringBuilder = errorText;
                if (stringBuilder != null) {
                    stringBuilder.append(' ');
                }
            }
            if (this.useOldFormat && location != null) {
                this.addLinkOpenTag(errorDetails, location);
            }
            errorDetails.append(XmlUtil.escape((String)descr));
            StringBuilder stringBuilder = errorText;
            if (stringBuilder != null) {
                stringBuilder.append(descr);
            }
            if (this.useOldFormat && location != null) {
                errorDetails.append("</a>");
            }
            if (!this.useOldFormat && location != null && addLink) {
                errorDetails.append(": ");
                this.addLinkOpenTag(errorDetails, location);
                errorDetails.append(FileUtil.getRelativePath((String)this.baseDirectoryPath, (String)location.getFilePath(), (char)File.separatorChar)).append(":").append(location.getLine()).append("</a>");
            }
            if (!isFirstMessage || !severalMessagesInRow) break block7;
            errorDetails.append('.');
            StringBuilder stringBuilder2 = errorText;
            if (stringBuilder2 != null) {
                stringBuilder2.append('.');
            }
        }
        return location;
    }

    private final void addLinkOpenTag(StringBuilder errorDetails, Location location) {
        errorDetails.append("<a href='#navigation_logical/").append(location.getFilePath()).append(":").append(location.getLine()).append(":").append(location.getColumn()).append("'>");
    }

    private final void addChildren(JsonArray extra, StringBuilder errorDetails) {
        for (JsonElement element : extra) {
            if (!(element instanceof JsonObject)) continue;
            JsonArray messageArray = ((JsonObject)element).getAsJsonArray("message");
            boolean isFirst = true;
            errorDetails.append("<br/>");
            Iterator iterator = messageArray.iterator();
            while (iterator.hasNext()) {
                JsonElement message;
                JsonElement jsonElement = message = (JsonElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"message");
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"message.asJsonObject");
                this.addMessage(null, errorDetails, jsonObject, true, isFirst, messageArray.size() > 1);
                isFirst = false;
            }
            JsonArray children = ((JsonObject)element).getAsJsonArray("children");
            if (children == null) continue;
            this.addChildren(children, errorDetails);
        }
    }

    private final Location parseLocation(JsonObject messageObject) {
        try {
            JsonElement jsonElement = messageObject.get("path");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"messageObject.get(\"path\")");
            String string = jsonElement.getAsString();
            if (string == null) {
                return null;
            }
            String filePath = string;
            JsonElement jsonElement2 = messageObject.get("loc");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"messageObject.get(\"loc\")");
            JsonObject loc = jsonElement2.getAsJsonObject();
            JsonElement jsonElement3 = loc.get("start");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"loc.get(\"start\")");
            JsonObject start = jsonElement3.getAsJsonObject();
            JsonElement jsonElement4 = loc.get("end");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"loc.get(\"end\")");
            JsonObject end = jsonElement4.getAsJsonObject();
            JsonElement jsonElement5 = start.get("line");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"start.get(\"line\")");
            int line = jsonElement5.getAsInt();
            JsonElement jsonElement6 = start.get("column");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"start.get(\"column\")");
            int column = jsonElement6.getAsInt();
            JsonElement jsonElement7 = start.get("offset");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"start.get(\"offset\")");
            int offset = jsonElement7.getAsInt();
            JsonElement jsonElement8 = end.get("line");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement8, (String)"end.get(\"line\")");
            int lineEnd = jsonElement8.getAsInt();
            JsonElement jsonElement9 = end.get("column");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement9, (String)"end.get(\"column\")");
            int columnEnd = jsonElement9.getAsInt() + 1;
            return new Location(filePath, line, column, lineEnd, columnEnd, offset);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private FlowJSErrorsParser(String targetFilePath, String baseDirectoryPath, JsonObject json) {
        super();
        this.targetFilePath = targetFilePath;
        this.baseDirectoryPath = baseDirectoryPath;
        flowVersionString = json.get("flowVersion");
        if (!(flowVersionString instanceof JsonPrimitive)) ** GOTO lbl-1000
        v0 = SemVer.parseFromText((String)((JsonPrimitive)flowVersionString).getAsString());
        if (v0 == null) ** GOTO lbl-1000
        if (!v0.isGreaterOrEqualThan(0, 66, 0)) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        this.useOldFormat = v1;
        listOfErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        try {
            errorArray = json.getAsJsonArray("errors");
            var8_8 = errorArray.iterator();
            while (var8_8.hasNext()) {
                v2 = error = (JsonElement)var8_8.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"error");
                if (!v2.isJsonObject()) continue;
                v3 = errorObject = error.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"errorObject");
                annotationResult = this.parseFlowError(v3);
                if (annotationResult == null) continue;
                listOfErrors.add(annotationResult);
            }
        }
        catch (Exception e) {
            FlowJSCliService.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        this.results = listOfErrors;
    }

    public /* synthetic */ FlowJSErrorsParser(@Nullable String targetFilePath, @NotNull String baseDirectoryPath, @NotNull JsonObject json, DefaultConstructorMarker $constructor_marker) {
        this(targetFilePath, baseDirectoryPath, json);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/flow/FlowJSErrorsParser$Companion;", "", "()V", "parseFlowErrors", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "targetFilePath", "", "baseDirectoryPath", "json", "Lcom/google/gson/JsonObject;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final List<JSAnnotationError> parseFlowErrors(@Nullable String targetFilePath, @NotNull String baseDirectoryPath, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)baseDirectoryPath, (String)"baseDirectoryPath");
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            return new FlowJSErrorsParser(targetFilePath, baseDirectoryPath, json, null).getResults();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

