/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSModuleImportOptimizerBase
implements ImportOptimizer {
    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @NotNull
    public Runnable processFile(PsiFile file2) {
        if (!JSOptimizeImportUtil.isAvailable(file2)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(0);
            }
            return runnable;
        }
        Collection<UnusedModuleInfo> infos = this.getModulesInfo(file2);
        if (infos.isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(1);
            }
            return runnable;
        }
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file2)) {
                return;
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = manager.getDocument(file2);
            if (document != null) {
                manager.commitDocument(document);
            }
            Project project = file2.getProject();
            FormatFixer.fixAll(ContainerUtil.mapNotNull((Collection)infos, info -> JSModuleImportOptimizerBase.processModule(project, document, info)));
        };
        if (runnable == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(2);
        }
        return runnable;
    }

    @Nullable
    private static FormatFixer processModule(@NotNull Project project, @Nullable Document document, @NotNull UnusedModuleInfo info) {
        if (project == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(3);
        }
        if (info == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(4);
        }
        List<PsiElement> oldImports = info.getOldImports();
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> commentInfos = JSModuleImportOptimizerBase.getCommentInfos(document, oldImports);
        List<String> importTexts = info.getImportTexts();
        PsiElement anchor = info.getAnchor();
        if (anchor == null) {
            return null;
        }
        FormatFixer formatFixer = null;
        if (!importTexts.isEmpty()) {
            formatFixer = JSOptimizeImportUtil.addNewImportTexts(importTexts, project, document, anchor);
        }
        JSModuleImportOptimizerBase.removeOldImports(oldImports, commentInfos);
        return formatFixer;
    }

    private static void removeOldImports(@NotNull List<PsiElement> oldImports, @NotNull Map<PsiElement, JSOptimizeImportUtil.CommentHolder> comments) {
        if (oldImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(5);
        }
        if (comments == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < oldImports.size(); ++i) {
            boolean isFirst = i == 0;
            PsiElement declaration = oldImports.get(i);
            JSOptimizeImportUtil.CommentHolder pair = comments.get(declaration);
            List<PsiElement> prevComments = pair.prevComments;
            PsiElement sameLineEndComment = pair.lineComment;
            boolean hasComments = prevComments.size() > 0;
            PsiElement beforeElement = hasComments ? prevComments.get(0) : declaration;
            PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
            JSOptimizeImportUtil.deleteSiblingWhitespaceBetweenImports(beforeElement, afterElement, !isFirst);
            if (hasComments || sameLineEndComment != null) {
                declaration.getParent().deleteChildRange(beforeElement, afterElement);
                continue;
            }
            declaration.delete();
        }
    }

    @NotNull
    private static HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> getCommentInfos(@Nullable Document document, @NotNull List<PsiElement> imports) {
        if (imports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(7);
        }
        HashMap prevDeclarations = ContainerUtil.newHashMap();
        for (PsiElement declaration : imports) {
            prevDeclarations.put(declaration, new JSOptimizeImportUtil.CommentHolder(JSOptimizeImportUtil.getPrevComments(document, declaration), JSOptimizeImportUtil.getLineComment(document, declaration)));
        }
        HashMap hashMap = prevDeclarations;
        if (hashMap == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    public abstract Collection<UnusedModuleInfo> getModulesInfo(PsiFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldImports";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeOldImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommentInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UnusedModuleInfo {
        @NotNull
        public List<String> getImportTexts();

        @Nullable
        public PsiElement getAnchor();

        @NotNull
        public List<PsiElement> getOldImports();
    }
}

