/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

public final class JavaScriptDebugSessionsUtil {
    private JavaScriptDebugSessionsUtil() {
    }

    public static boolean stopDebugSessions(String message, Class<? extends JavaScriptDebugProcess<? extends VmConnection>> processClass) {
        SmartList sessions = new SmartList();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (JavaScriptDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(processClass)) {
                XDebugSession session = process.getSession();
                if (session.isStopped()) continue;
                sessions.add(session);
            }
        }
        if (!sessions.isEmpty()) {
            int count = sessions.size();
            String sessionName = count == 1 ? "'" + ((XDebugSession)sessions.get(0)).getSessionName() + "'" : String.valueOf(count);
            int answer = Messages.showYesNoDialog((String)JSDebuggerBundle.message("message.text.do.you.want.to.stop.0.sessions", message, sessionName, count), (String)JSDebuggerBundle.message("dialog.title.stop.debugger.session", new Object[0]), null);
            if (answer == 0) {
                for (XDebugSession session : sessions) {
                    session.stop();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static RunnerAndConfigurationSettings findExistingConfiguration(String url, Project project) {
        for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)JavascriptDebugConfigurationType.getTypeInstance())) {
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof JavaScriptDebugConfiguration) || !url.equals(((JavaScriptDebugConfiguration)configuration).getUri())) continue;
            return settings;
        }
        return null;
    }
}

