/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.FunctionContext;
import org.intellij.lang.xpath.context.functions.XPathFunctionProvider;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFunctionContext
implements FunctionContext {
    private static final Map<ContextType, FunctionContext> ourInstances = new HashMap<ContextType, FunctionContext>();
    private final Map<Pair<QName, Integer>, Function> myFunctions;
    private final Map<QName, Function> myDefaultMap = new HashMap<QName, Function>();

    protected AbstractFunctionContext(ContextType contextType) {
        assert (!ourInstances.containsKey(contextType));
        this.myFunctions = Collections.unmodifiableMap(new HashMap(ContainerUtil.union(this.createFunctionMap(contextType), AbstractFunctionContext.getProvidedFunctions(contextType))));
        for (Map.Entry<Pair<QName, Integer>, Function> entry : this.myFunctions.entrySet()) {
            Function function = entry.getValue();
            Function prev = this.myDefaultMap.get(entry.getKey().first);
            if (prev != null) {
                if (prev.getParameters().length <= function.getParameters().length) continue;
                this.myDefaultMap.put((QName)entry.getKey().first, function);
                continue;
            }
            this.myDefaultMap.put((QName)entry.getKey().first, function);
        }
        ourInstances.put(contextType, this);
    }

    protected abstract Map<Pair<QName, Integer>, Function> createFunctionMap(ContextType var1);

    private static Map<Pair<QName, Integer>, Function> getProvidedFunctions(ContextType contextType) {
        HashMap<Pair, Object> map = new HashMap<Pair, Object>();
        List<Pair<QName, ? extends Function>> availableFunctions = XPathFunctionProvider.getAvailableFunctions(contextType);
        for (Pair<QName, ? extends Function> pair : availableFunctions) {
            map.put(Pair.create((Object)pair.first, (Object)((Function)pair.second).getParameters().length), pair.second);
        }
        return Collections.unmodifiableMap(map);
    }

    protected static synchronized FunctionContext getInstance(ContextType contextType, Factory<? extends FunctionContext> factory) {
        return ourInstances.computeIfAbsent(contextType, k -> (FunctionContext)factory.create());
    }

    public Map<Pair<QName, Integer>, Function> getFunctions() {
        return this.myFunctions;
    }

    @Override
    @Nullable
    public Function resolve(QName name, int argCount) {
        if (!this.myDefaultMap.containsKey(name)) {
            return null;
        }
        Function function = this.getFunctions().get(Pair.create((Object)name, (Object)argCount));
        if (function != null) {
            return function;
        }
        return this.myDefaultMap.get(name);
    }
}

