/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.hooks.DrupalHookInvocationMethod;

public class DrupalHookIndexDescription {
    private final String myName;
    private final DrupalVersion myMinVersion;

    public DrupalHookIndexDescription(String name, DrupalVersion version) {
        this.myName = name;
        this.myMinVersion = version;
    }

    public DrupalHookIndexDescription(String hook, DrupalHookInvocationMethod method) {
        this(hook, DrupalVersion.findOldestVersion(method));
    }

    public String getName() {
        return this.myName;
    }

    public DrupalVersion getMinVersion() {
        return this.myMinVersion;
    }

    public boolean suits(DrupalVersion version) {
        return this.myMinVersion.getNumber() <= version.getNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrupalHookIndexDescription that = (DrupalHookIndexDescription)o;
        if (this.myMinVersion != that.myMinVersion) {
            return false;
        }
        return this.myName.equals(that.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myMinVersion.getNumber();
        return result;
    }
}

