/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Locale;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.provider.ftp.MLSxLoggingEntryParser;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;

public class FTPSExtendedClient
extends FTPSClient {
    private static final Log log = LogFactory.getLog((String)"#com.jetbrains.plugins.webDeployment.ftps");
    private SocketFactoryWrapper mySocketFactoryWrapper;
    private ServerSocketFactoryWrapper myServerSocketFactoryWrapper;
    private final boolean myShareSslContext;

    FTPSExtendedClient(boolean shareContext) {
        this.myShareSslContext = shareContext;
        this.setStrictReplyParsing(false);
    }

    FTPSExtendedClient(boolean isImplicit, boolean shareContext) {
        super(isImplicit);
        this.myShareSslContext = shareContext;
        this.setStrictReplyParsing(false);
    }

    public SocketFactoryWrapper getSocketFactoryWrapper() {
        return this.mySocketFactoryWrapper;
    }

    public void setSocketFactoryWrapper(SocketFactoryWrapper socketFactoryWrapper) {
        this.mySocketFactoryWrapper = socketFactoryWrapper;
    }

    public ServerSocketFactoryWrapper getServerSocketFactoryWrapper() {
        return this.myServerSocketFactoryWrapper;
    }

    public void setServerSocketFactoryWrapper(ServerSocketFactoryWrapper serverSocketFactoryWrapper) {
        this.myServerSocketFactoryWrapper = serverSocketFactoryWrapper;
    }

    public void setSocketFactory(SocketFactory factory) {
        if (factory == null) {
            factory = SocketFactory.getDefault();
        }
        if (this.mySocketFactoryWrapper != null) {
            factory = this.mySocketFactoryWrapper.wrap(factory);
        }
        super.setSocketFactory(factory);
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        if (factory == null) {
            factory = ServerSocketFactory.getDefault();
        }
        if (this.myServerSocketFactoryWrapper != null) {
            factory = this.myServerSocketFactoryWrapper.wrap(factory);
        }
        super.setServerSocketFactory(factory);
    }

    public FTPFile[] mlistDir() throws IOException {
        return this.mlistDir(null);
    }

    public FTPFile[] mlistDir(String pathname) throws IOException {
        FTPListParseEngine engine = this.initiateMListParsing(pathname);
        return engine.getFiles();
    }

    public FTPFile[] mlistDir(String pathname, FTPFileFilter filter) throws IOException {
        FTPListParseEngine engine = this.initiateMListParsing(pathname);
        return engine.getFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateMListParsing(String pathname) throws IOException {
        FTPListParseEngine engine = new FTPListParseEngine((FTPFileEntryParser)new MLSxLoggingEntryParser(log));
        Socket socket = this._openDataConnection_(38, pathname);
        if (socket == null) {
            return engine;
        }
        try {
            engine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly((Socket)socket);
            this.completePendingCommand();
        }
        return engine;
    }

    protected void _prepareDataSocket_(Socket socket) throws IOException {
        super._prepareDataSocket_(socket);
        if (this.myShareSslContext && socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            SSLSessionContext context = session.getSessionContext();
            try {
                Field sessionHostPortCache = context.getClass().getDeclaredField("sessionHostPortCache");
                sessionHostPortCache.setAccessible(true);
                Object cache = sessionHostPortCache.get(context);
                Method putMethod = cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                putMethod.setAccessible(true);
                Method getHostMethod = socket.getClass().getDeclaredMethod("getHost", new Class[0]);
                getHostMethod.setAccessible(true);
                Object host = getHostMethod.invoke((Object)socket, new Object[0]);
                String key = String.format("%s:%s", host, String.valueOf(socket.getPort())).toLowerCase(Locale.ROOT);
                putMethod.invoke(cache, key, session);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

